/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.jackson.JSONException;
import com.huawei.security.validator.util.jackson.JSONObject;
import com.huawei.security.validator.util.jackson.JsonJacksonUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;

public class JSONArray
extends ArrayList<Object> {
    private static final long serialVersionUID = 5871970967397101346L;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private final List<Object> elements = new ArrayList<Object>(10);

    public static <T> JSONArray fromObject(T object) throws JSONException {
        ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
        return JSONArray.fromObject(object, objectMapper);
    }

    public static <T> JSONArray fromObject(T object, ObjectMapper objectMapper) throws JSONException {
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        JSONArray jsonArray = new JSONArray();
        try {
            if (!(object instanceof String)) {
                if (object instanceof Collection || object instanceof String[]) {
                    String arrayStr = objectMapper.writeValueAsString(object);
                    return JSONArray.fromObject(arrayStr, objectMapper);
                }
                return jsonArray;
            }
            List list = (List)objectMapper.readValue(object.toString(), (TypeReference)new TypeReference<List<Object>>(){});
            JSONArray.convertElement(jsonArray, list, objectMapper);
        }
        catch (IOException e) {
            LOG.error("[WSF-ParamValidate] Gets JSONArray from object failed.");
            throw new JSONException("Gets JSONArray from object failed.", e);
        }
        return jsonArray;
    }

    private static void convertElement(JSONArray array, List<?> list, ObjectMapper objectMapper) {
        if (list == null) {
            return;
        }
        Serializable tempEle = null;
        for (Object ele : list) {
            tempEle = ele instanceof Map && !(ele instanceof JSONObject) ? JSONObject.fromObject(ele, objectMapper) : (ele instanceof Collection && !(ele instanceof JSONArray) ? JSONArray.fromObject(ele, objectMapper) : (Serializable)ele);
            array.elements.add(tempEle);
        }
    }

    @Override
    public Object get(int index) {
        return this.elements.get(index);
    }

    @Override
    public String toString() throws JSONException {
        try {
            ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
            return objectMapper.writeValueAsString(this.elements);
        }
        catch (JsonProcessingException e) {
            LOG.error("[WSF-ParamValidate] Converts JSONArray to String failed.");
            throw new JSONException("Converts JSONArray to String failed.", e);
        }
    }

    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass() || !super.equals(object)) {
            return false;
        }
        JSONArray objects = (JSONArray)object;
        return this.elements.equals(objects.elements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elements);
    }
}

