/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> innerIterator;
    private E peek;
    private boolean isPeek = false;
    private E currentNode = null;

    public static <T> JsonIterator<T> getIteratorInstance(Iterable<T> iterable) {
        return new JsonIterator<T>(iterable.iterator());
    }

    public JsonIterator(Iterator<? extends E> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        this.innerIterator = iterator;
    }

    private void peeking() {
        this.peek = this.innerIterator.next();
        this.isPeek = true;
    }

    public E getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext() || this.isPeek;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.isPeek) {
            this.isPeek = false;
            this.currentNode = this.peek;
            return this.currentNode;
        }
        this.peeking();
        return this.next();
    }

    public E peekNode() {
        if (!this.isPeek && this.hasNext()) {
            this.peeking();
        }
        if (!this.isPeek) {
            throw new NoSuchElementException();
        }
        return this.peek;
    }
}

