/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.gson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.gson.JsonObject;
import java.util.Objects;

public final class JsonValue
implements JsonBaseCore<JsonValue> {
    private final JsonElement gsonValue;

    public JsonValue(JsonElement jsonValue) {
        this.gsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.gsonValue.isJsonObject();
    }

    @Override
    public boolean isArray() {
        return this.gsonValue.isJsonArray();
    }

    @Override
    public boolean isString() {
        return this.gsonValue.isJsonPrimitive() && this.gsonValue.getAsJsonPrimitive().isString();
    }

    public JsonObject asObject() {
        return new JsonObject(this.gsonValue.getAsJsonObject());
    }

    public JsonArray asArray() {
        return new JsonArray(this.gsonValue.getAsJsonArray());
    }

    public JsonValue asValue() {
        return this;
    }

    @Override
    public String asString() {
        return this.gsonValue.getAsString();
    }

    @Override
    public boolean isNull() {
        return this.gsonValue == null || this.gsonValue instanceof JsonNull;
    }

    public int hashCode() {
        return this.gsonValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonValue)) {
            return false;
        }
        return Objects.equals(this.gsonValue, ((JsonValue)obj).gsonValue);
    }

    public String toString() {
        return this.gsonValue.toString();
    }

    public JsonElement getSource() {
        return this.gsonValue;
    }
}

