/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonObjectCore;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonValue;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class JsonObject
implements JsonObjectCore<JsonValue> {
    private final ObjectNode jackSonJsonObject;

    public JsonObject(ObjectNode jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.jackSonJsonObject = jsonObject;
    }

    @Override
    public Optional<JsonBaseCore<?>> get(String name) {
        JsonNode node = this.jackSonJsonObject.get(name);
        return node == null ? Optional.empty() : Optional.of(new JsonValue(node));
    }

    public int hashCode() {
        return this.jackSonJsonObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        return Objects.equals(this.jackSonJsonObject, ((JsonObject)obj).jackSonJsonObject);
    }

    public String toString() {
        return this.jackSonJsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, JsonValue>> iterator() {
        return new JacksonJsonEntryIterator(this.jackSonJsonObject.fields());
    }

    @Override
    public int size() {
        return this.jackSonJsonObject.size();
    }

    @Override
    public void set(String name, JsonBaseCore jsonValue) {
        Object source = jsonValue.getSource();
        if (!(source instanceof JsonNode)) {
            throw new UnsupportedOperationException();
        }
        this.jackSonJsonObject.set(name, (JsonNode)source);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(String name) {
        return this.jackSonJsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.jackSonJsonObject.has(name);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    public JsonObject asObject() {
        return this;
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    public JsonValue asValue() {
        return new JsonValue((JsonNode)this.jackSonJsonObject);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public Object getSource() {
        return this.jackSonJsonObject;
    }

    @Override
    public Iterator<String> names() {
        return this.jackSonJsonObject.fieldNames();
    }

    private static class JacksonJsonEntryIterator
    implements Iterator<Map.Entry<String, JsonValue>> {
        private final Iterator<Map.Entry<String, JsonNode>> jsonNodeIterator;

        private JacksonJsonEntryIterator(Iterator<Map.Entry<String, JsonNode>> jsonNodeIterator) {
            this.jsonNodeIterator = jsonNodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jsonNodeIterator.hasNext();
        }

        @Override
        public Map.Entry<String, JsonValue> next() {
            Map.Entry<String, JsonNode> member = this.jsonNodeIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, JsonValue>(member.getKey(), new JsonValue(member.getValue()));
        }
    }
}

