/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.jackson.JsonObject;
import java.util.Objects;

public final class JsonValue
implements JsonBaseCore<JsonValue> {
    private final JsonNode jackSonJsonValue;

    public JsonValue(JsonNode jsonValue) {
        this.jackSonJsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.jackSonJsonValue.isObject();
    }

    @Override
    public boolean isArray() {
        return this.jackSonJsonValue.isArray();
    }

    @Override
    public boolean isString() {
        return this.jackSonJsonValue.isTextual();
    }

    public JsonObject asObject() {
        if (!(this.jackSonJsonValue instanceof ObjectNode)) {
            throw new UnsupportedOperationException();
        }
        ObjectNode jsonObj = (ObjectNode)this.jackSonJsonValue;
        return new JsonObject(jsonObj);
    }

    public JsonArray asArray() {
        return new JsonArray((ArrayNode)this.jackSonJsonValue);
    }

    public JsonValue asValue() {
        return this;
    }

    @Override
    public String asString() {
        return this.jackSonJsonValue.asText();
    }

    @Override
    public boolean isNull() {
        return this.jackSonJsonValue == null || this.jackSonJsonValue instanceof NullNode;
    }

    public int hashCode() {
        return this.jackSonJsonValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonValue)) {
            return false;
        }
        return Objects.equals(this.jackSonJsonValue, ((JsonValue)obj).jackSonJsonValue);
    }

    public String toString() {
        return this.jackSonJsonValue.toString();
    }

    public JsonNode getSource() {
        return this.jackSonJsonValue;
    }
}

