/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.RegExpExecutor;
import com.huawei.security.validator.util.Resources;
import com.huawei.security.validator.util.ValidatorUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;

public class CharacterWhiteValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult(true);
        String errorCode = ValidatorEnum.CHARACTER_WHITE_VALIDATOR.name();
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
            return result;
        }
        if (validateRuleMap == null || validateRuleMap.get("path") == null) {
            LOG.error("[WSF-ParamValidate] CharacterWhiteValidator:attribute path config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
            return result;
        }
        String propertiesFilePath = validateRuleMap.get("path");
        List<String> validatorRule = this.loadProperties(propertiesFilePath, result, errorKey, errorMessage);
        boolean validateResult = true;
        try {
            String validateRule;
            Iterator<String> iterator = validatorRule.iterator();
            while (iterator.hasNext() && !(validateResult = RegExpExecutor.validate(validateRule = iterator.next(), true, inputValidate, false))) {
            }
        }
        catch (PatternSyntaxException ex) {
            LOG.error("[WSF-ParamValidate] The regexp for CharacterWhiteValidator is wrong. wrong message: {}.", (Object)LogUtils.cleanLog(ex.getMessage()));
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        if (!validateResult) {
            LOG.error("[WSF-ParamValidate] CHARACTER_WHITE_VALIDATOR validate fail.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadProperties(String filePath, ValidatorResult result, String errorKey, String errorMessage) {
        LOG.debug("[WSF-ParamValidate] Config path is {}.", (Object)LogUtils.cleanLog(filePath));
        try (InputStream in = Resources.getResourceAsStream(filePath);){
            Properties properties = new Properties();
            properties.load(in);
            ArrayList<String> validatorRule = new ArrayList<String>(properties.size());
            for (Object value : properties.values()) {
                if (!(value instanceof String)) continue;
                validatorRule.add((String)value);
            }
            ArrayList<String> arrayList = validatorRule;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error("[WSF-ParamValidate] Cannot Load properties file for character white validator: IOException.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.CHARACTER_WHITE_VALIDATOR.name(), new Object[0]);
            return new ArrayList<String>(0);
        }
    }
}

