/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.IPUtil;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import org.slf4j.Logger;

public class IPValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.IP_VALIDATOR.name(), new Object[0]);
            return result;
        }
        if (inputValidate instanceof String && !IPUtil.checkIP(String.valueOf(inputValidate))) {
            LOG.error("[WSF-ParamValidate] {} validate fail.", (Object)ValidatorEnum.IP_VALIDATOR);
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.IP_VALIDATOR.name(), new Object[0]);
            return result;
        }
        return result;
    }
}

