/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.ValidatorUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import org.slf4j.Logger;

public class MaxValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (validateRuleMap == null || validateRuleMap.get("maxValue") == null) {
            LOG.error("[WSF-ParamValidate] MaxValidator:attribute maxValue config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_VALIDATOR.name(), new Object[0]);
            return result;
        }
        String maxConfig = validateRuleMap.get("maxValue");
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_VALIDATOR.name(), maxConfig);
            return result;
        }
        if (maxConfig.contains(".")) {
            this.validateDecimalParam(maxConfig, inputValidate.toString(), result, errorKey, errorMessage);
        } else {
            this.validateLongParam(maxConfig, inputValidate.toString(), result, errorKey, errorMessage);
        }
        if (!result.isValidateResule()) {
            LOG.error("[WSF-ParamValidate] MAX_VALIDATOR validate fail.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_VALIDATOR.name(), maxConfig);
            return result;
        }
        return result;
    }

    private void validateDecimalParam(String maxConfig, String inputData, ValidatorResult result, String errorKey, String errorMessage) {
        BigDecimal inputDecimal;
        BigDecimal configDecimal;
        try {
            configDecimal = new BigDecimal(maxConfig);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MAX_VALIDATOR validate fail, config max value {} isn't correct.", (Object)LogUtils.cleanLog(maxConfig));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_VALIDATOR.name(), maxConfig);
            return;
        }
        try {
            inputDecimal = new BigDecimal(inputData);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MAX_VALIDATOR validate fail, input value {} isn't digit.", (Object)LogUtils.cleanLog(maxConfig));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_VALIDATOR.name(), maxConfig);
            return;
        }
        if (configDecimal.compareTo(inputDecimal) < 0) {
            result.setValidateResule(false);
        }
    }

    private void validateLongParam(String maxConfig, String inputData, ValidatorResult result, String errorKey, String errorMessage) {
        long inputValue;
        long maxValue;
        try {
            maxValue = Long.parseLong(maxConfig);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MAX_VALIDATOR validate fail, config max value {} isn't correct.", (Object)LogUtils.cleanLog(maxConfig));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_VALIDATOR.name(), maxConfig);
            return;
        }
        try {
            inputValue = Long.parseLong(inputData);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MAX_VALIDATOR validate fail, input value {} isn't digit.", (Object)LogUtils.cleanLog(maxConfig));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MAX_VALIDATOR.name(), maxConfig);
            return;
        }
        if (inputValue > maxValue) {
            result.setValidateResule(false);
        }
    }
}

