/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.ValidatorUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;

public class MinLengthValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (validateRuleMap == null || validateRuleMap.get("minLength") == null) {
            LOG.error("[WSF-ParamValidate] MIN_LENGTH_VALIDATOR validate fail. MinLengthValidator:attribute minLength config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_LENGTH_VALIDATOR.name(), new Object[0]);
            return result;
        }
        if (validateRuleMap.get("mark") != null && !validateRuleMap.get("mark").equalsIgnoreCase("extend")) {
            LOG.error("[WSF-ParamValidate] MIN_LENGTH_VALIDATOR validate fail. MinLengthValidator:attribute mark config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_LENGTH_VALIDATOR.name(), new Object[0]);
            return result;
        }
        String minLengthString = validateRuleMap.get("minLength");
        String mark = validateRuleMap.get("mark");
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] MIN_LENGTH_VALIDATOR validate fail. Input validate parameter value is null or validate rule is error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_LENGTH_VALIDATOR.name(), minLengthString);
            return result;
        }
        try {
            int inputLength = "extend".equalsIgnoreCase(mark) ? inputValidate.toString().getBytes(StandardCharsets.UTF_8).length : inputValidate.toString().length();
            int minLength = Integer.parseInt(minLengthString);
            if (inputLength < minLength) {
                LOG.error("[WSF-ParamValidate] MIN_LENGTH_VALIDATOR validate fail.");
                ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_LENGTH_VALIDATOR.name(), minLengthString);
                return result;
            }
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MIN_LENGTH_VALIDATOR validate fail. Set minLength {} is not valid.", (Object)LogUtils.cleanLog(minLengthString));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_LENGTH_VALIDATOR.name(), minLengthString);
            return result;
        }
        return result;
    }
}

