/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.ValidatorUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import org.slf4j.Logger;

public class MinValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (validateRuleMap == null || validateRuleMap.get("minValue") == null) {
            LOG.error("[WSF-ParamValidate] MinValidator:attribute minValue config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_VALIDATOR.name(), new Object[0]);
            return result;
        }
        String configMin = validateRuleMap.get("minValue");
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_VALIDATOR.name(), configMin);
            return result;
        }
        if (configMin.contains(".")) {
            this.validateDecimalParam(configMin, inputValidate.toString(), result, errorKey, errorMessage);
        } else {
            this.validateLongParam(configMin, inputValidate.toString(), result, errorKey, errorMessage);
        }
        if (!result.isValidateResule()) {
            LOG.error("[WSF-ParamValidate] MIN_VALIDATOR validate fail.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_VALIDATOR.name(), configMin);
            return result;
        }
        return result;
    }

    private void validateDecimalParam(String configMin, String inputData, ValidatorResult result, String errorKey, String errorMessage) {
        BigDecimal inputDecimal;
        BigDecimal configDecimal;
        try {
            configDecimal = new BigDecimal(configMin);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MIN_VALIDATOR validate fail, config min value {} isn't correct.", (Object)LogUtils.cleanLog(configMin));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_VALIDATOR.name(), configMin);
            return;
        }
        try {
            inputDecimal = new BigDecimal(inputData);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MIN_VALIDATOR validate fail, input value {} isn't digit.", (Object)LogUtils.cleanLog(configMin));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_VALIDATOR.name(), configMin);
            return;
        }
        if (configDecimal.compareTo(inputDecimal) > 0) {
            result.setValidateResule(false);
        }
    }

    private void validateLongParam(String configMin, String inputData, ValidatorResult result, String errorKey, String errorMessage) {
        long inputValue;
        long minValue;
        try {
            minValue = Long.parseLong(configMin);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MIN_VALIDATOR validate fail, config min value {} isn't correct.", (Object)LogUtils.cleanLog(configMin));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_VALIDATOR.name(), configMin);
            return;
        }
        try {
            inputValue = Long.parseLong(inputData);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] MIN_VALIDATOR validate fail, input value {} isn't digit.", (Object)LogUtils.cleanLog(configMin));
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.MIN_VALIDATOR.name(), configMin);
            return;
        }
        if (inputValue < minValue) {
            result.setValidateResule(false);
        }
    }
}

