/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.ValidatorUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;

public class RangeLengthValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        boolean invalidMark;
        if (validateRuleMap == null || validateRuleMap.get("minLength") == null || validateRuleMap.get("maxLength") == null) {
            LOG.error("[WSF-ParamValidate] Attribute minLength or maxLength config error, so the result is false.");
            String errorCode = ValidatorEnum.RANGE_LENGTH_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        boolean bl = invalidMark = validateRuleMap.get("mark") != null && !validateRuleMap.get("mark").equalsIgnoreCase("extend");
        if (invalidMark) {
            LOG.error("[WSF-ParamValidate] Attribute mark config error, so the result is false.");
            String errorCode = ValidatorEnum.RANGE_LENGTH_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        String minLength = validateRuleMap.get("minLength");
        String maxLength = validateRuleMap.get("maxLength");
        String mark = validateRuleMap.get("mark");
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] RangeLengthValidator:Input parameter value is null, so the result is false.");
            String errorCode = ValidatorEnum.RANGE_LENGTH_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, minLength, maxLength);
        }
        try {
            int valueStringLength;
            int minValue = Integer.parseInt(validateRuleMap.get("minLength"));
            int maxValue = Integer.parseInt(validateRuleMap.get("maxLength"));
            String valueString = String.valueOf(inputValidate);
            int n = valueStringLength = "extend".equalsIgnoreCase(mark) ? valueString.getBytes(StandardCharsets.UTF_8).length : valueString.length();
            if (valueStringLength < minValue || valueStringLength > maxValue) {
                LOG.error("[WSF-ParamValidate] RANGE_LENGTH_VALIDATOR validate fail.");
                String errorCode = ValidatorEnum.RANGE_LENGTH_VALIDATOR.name();
                return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, minLength, maxLength);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-ParamValidate] RANGE_LENGTH_VALIDATOR validate fail. Set maxLength or minLength is not valid, minLength is {}, maxLength is {}.", (Object)LogUtils.cleanLog(minLength), (Object)LogUtils.cleanLog(maxLength));
            String errorCode = ValidatorEnum.RANGE_LENGTH_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, minLength, maxLength);
        }
        return new ValidatorResult(true);
    }
}

