/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.RegExpExecutor;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;

public class RegExpValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        String errorCode = ValidatorEnum.REGEXP_VALIDATOR.name();
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        if (validateRuleMap == null || validateRuleMap.get("rule") == null) {
            LOG.error("[WSF-ParamValidate] RegExpValidator:attribute rule config error, so the result is false.");
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        boolean caseSensitive = false;
        String sensitive = validateRuleMap.get("caseSensitive");
        if (!EmptyUtils.isEmpty(sensitive)) {
            caseSensitive = Boolean.parseBoolean(sensitive);
        }
        boolean blackListCheck = false;
        String listCheck = validateRuleMap.get("blacklistcheck");
        if (listCheck != null && "true".equalsIgnoreCase(listCheck.trim())) {
            blackListCheck = true;
        }
        String expression = validateRuleMap.get("rule");
        try {
            boolean validateSuccess = RegExpExecutor.validate(expression, caseSensitive, inputValidate, false);
            if (blackListCheck == validateSuccess) {
                LOG.error("[WSF-ParamValidate] REGEXP_VALIDATOR validate fail.");
                return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
            }
        }
        catch (PatternSyntaxException ex) {
            LOG.error("[WSF-ParamValidate] The regexp for RegExpValidator is wrong. wrong message: {}.", (Object)LogUtils.cleanLog(ex.getMessage()));
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        return new ValidatorResult(true);
    }
}

