/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.ValidatorUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;

public class SameDomainValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        boolean validateSuccess = true;
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null.");
            String errorCode = ValidatorEnum.SAME_DOMAIN_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        if (validateRuleMap == null || validateRuleMap.get("domain") == null) {
            LOG.error("[WSF-ParamValidate] SameDomainValidator:attribute domain config error, so the result is false.");
            String errorCode = ValidatorEnum.SAME_DOMAIN_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        String confDomain = validateRuleMap.get("domain");
        String inputValue = String.valueOf(inputValidate);
        URI uri = URI.create(inputValue);
        String domain = uri.getHost();
        if (domain != null) {
            String serverDomain;
            if (!(domain = domain.replaceAll(".*\\.(?=.*\\.)", "").toLowerCase(Locale.ENGLISH)).equals(serverDomain = confDomain.replaceAll(".*\\.(?=.*\\.)", "").toLowerCase(Locale.ENGLISH))) {
                validateSuccess = false;
            }
        } else {
            validateSuccess = false;
        }
        if (!validateSuccess) {
            LOG.error("[WSF-ParamValidate] SAME_DOMAIN_VALIDATOR validate fail.");
            String errorCode = ValidatorEnum.SAME_DOMAIN_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        return new ValidatorResult(true);
    }
}

