/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.outerinterface.ParameterSetNameInterface;
import com.huawei.security.validator.outerinterface.ValidateErrorHandler;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;

public final class ValidatorFactory {
    private ValidatorFactory() {
    }

    public static Validator getValidator(String classPath) throws ValidateException {
        try {
            Object validatorInstance = Class.forName(classPath).newInstance();
            if (validatorInstance instanceof Validator) {
                return (Validator)validatorInstance;
            }
            throw new ValidateException("The " + LogUtils.cleanLog(classPath) + " should implement Validator interface.");
        }
        catch (ClassNotFoundException e) {
            throw new ValidateException("Class not found: " + LogUtils.cleanLog(classPath) + ".", e);
        }
        catch (InstantiationException e) {
            throw new ValidateException("Instantiation class fail, class path: " + LogUtils.cleanLog(classPath) + ".", e);
        }
        catch (IllegalAccessException e) {
            throw new ValidateException("IllegalAccess to class: " + LogUtils.cleanLog(classPath) + ".", e);
        }
    }

    public static ValidateErrorHandler getValidateHandler(String classPath) throws ValidateException {
        try {
            Object errorHandlerInstance = Class.forName(classPath).newInstance();
            if (errorHandlerInstance instanceof ValidateErrorHandler) {
                return (ValidateErrorHandler)errorHandlerInstance;
            }
            throw new ValidateException("The " + LogUtils.cleanLog(classPath) + " should implement ValidateErrorHandler interface.");
        }
        catch (ClassNotFoundException e) {
            throw new ValidateException("Class not found: " + LogUtils.cleanLog(classPath) + ".", e);
        }
        catch (InstantiationException e) {
            throw new ValidateException("Instantiation class fail, class path: " + LogUtils.cleanLog(classPath) + ".", e);
        }
        catch (IllegalAccessException e) {
            throw new ValidateException("IllegalAccess to class: " + LogUtils.cleanLog(classPath) + ".", e);
        }
    }

    public static ParameterSetNameInterface getParameterSetNameInterface(String classPath) throws ValidateException {
        try {
            Object paramSetNameInstance = Class.forName(classPath).newInstance();
            if (paramSetNameInstance instanceof ParameterSetNameInterface) {
                return (ParameterSetNameInterface)paramSetNameInstance;
            }
            throw new ValidateException("The " + LogUtils.cleanLog(classPath) + " should implement ParameterSetNameInterface interface.");
        }
        catch (ClassNotFoundException e) {
            throw new ValidateException("Class not found: " + LogUtils.cleanLog(classPath) + ".", e);
        }
        catch (InstantiationException e) {
            throw new ValidateException("Instantiation class fail, class path: " + LogUtils.cleanLog(classPath) + ".", e);
        }
        catch (IllegalAccessException e) {
            throw new ValidateException("IllegalAccess to class: " + LogUtils.cleanLog(classPath) + ".", e);
        }
    }
}

