/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.RegExpExecutor;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class XSSValidator
implements Validator {
    private static final String XSS_FILTERS_CATEGORY1 = "(?i)[<\uff1c]script[^>\uff1e]*[>\uff1e][\\s\\S]*?";
    private static final String XSS_FILTERS_CATEGORY2 = "(?i)[\\s\\\"'`;\\/0-9=\\x0B\\x09\\x0C\\x3B\\x2C\\x28\\x3B]+on[a-zA-Z]+[\\s\\x0B\\x09\\x0C\\x3B\\x2C\\x28\\x3B]*?=";
    private static final String XSS_FILTERS_CATEGORY2_PRE_EXPRESSION = "(?i)on[a-zA-Z]+[\\s\\x0B\\x09\\x0C\\x3B\\x2C\\x28\\x3B]*?=";
    private static final String XSS_FILTERS_CATEGORY3 = "(?i)(?:<(?:(?:apple|objec)t|isindex|embed|style|form|meta)\\b[^>]*?>[\\s\\S]*?|(?:=|U\\s*?R\\s*?L\\s*?\\()\\s*?[^>]*?\\s*?S\\s*?C\\s*?R\\s*?I\\s*?P\\s*?T\\s*?:)";
    private static final String XSS_FILTERS_CATEGORY4 = "(?i)[\\s\\S](?:x(?:link:href|html|mlns)|!ENTITY.*?SYSTEM|data:text\\/html|pattern(?=.*?=)|formaction|\\@import|base64)\\b";
    private static final String XSS_FILTERS_CATEGORY5 = "(?i)\\b(?:s(?:tyle|rc)|href)\\b[\\s\\S]*?=";
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final String[] RULEARRAY = new String[]{"(?i)[<\uff1c]script[^>\uff1e]*[>\uff1e][\\s\\S]*?", "(?i)(?:<(?:(?:apple|objec)t|isindex|embed|style|form|meta)\\b[^>]*?>[\\s\\S]*?|(?:=|U\\s*?R\\s*?L\\s*?\\()\\s*?[^>]*?\\s*?S\\s*?C\\s*?R\\s*?I\\s*?P\\s*?T\\s*?:)", "(?i)[\\s\\S](?:x(?:link:href|html|mlns)|!ENTITY.*?SYSTEM|data:text\\/html|pattern(?=.*?=)|formaction|\\@import|base64)\\b", "(?i)\\b(?:s(?:tyle|rc)|href)\\b[\\s\\S]*?="};
    private static final Map<String, String[]> RULES_PRE_RULES = new HashMap<String, String[]>();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            String errorCode = ValidatorEnum.XSS_ATTACK_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        for (String xssRule : RULEARRAY) {
            boolean validateResult = RegExpExecutor.validate(xssRule, false, inputValidate, true);
            if (!validateResult) continue;
            LOG.error("[WSF-ParamValidate] XSS_ATTACK_VALIDATOR validate fail.");
            String errorCode = ValidatorEnum.XSS_ATTACK_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        for (Map.Entry entry : RULES_PRE_RULES.entrySet()) {
            if (!RegExpExecutor.validateWithPreExpressions((String)entry.getKey(), (String[])entry.getValue(), false, inputValidate, true)) continue;
            LOG.error("[WSF-ParamValidate] XSS_ATTACK_VALIDATOR with pre expressions validate fail.");
            return ValidatorUtil.getResult(errorKey, errorMessage, ValidatorEnum.XSS_ATTACK_VALIDATOR.name(), false, new Object[0]);
        }
        return new ValidatorResult(true);
    }

    static {
        RULES_PRE_RULES.put(XSS_FILTERS_CATEGORY2, new String[]{XSS_FILTERS_CATEGORY2_PRE_EXPRESSION});
    }
}

