/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.web;

import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.web.JsonChecker;
import org.slf4j.Logger;

public final class JsonCheckerFactory {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static JsonChecker jsonChecker = null;

    private JsonCheckerFactory() {
    }

    public static JsonChecker getJsonChecker() {
        return jsonChecker;
    }

    static {
        Class<?> clazz = null;
        try {
            String classPath = FileCache.getInstance().getCommonConfigsBean().getJsonPreCheckPath();
            if (!EmptyUtils.isEmpty(classPath)) {
                clazz = Class.forName(classPath);
            } else {
                LOG.info("[WSF-ParamValidate] The classpath is empty, it will use WSF JsonChecker.");
                clazz = Class.forName("com.huawei.security.validator.web.DefaultJsonChecker");
            }
            Object jsonCheckerInstance = clazz.newInstance();
            if (jsonCheckerInstance instanceof JsonChecker) {
                jsonChecker = (JsonChecker)jsonCheckerInstance;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.error(ex.getMessage());
        }
        if (jsonChecker == null) {
            LOG.info("[WSF-ParamValidate] The checker have failed, it will use wsf JsonChecker default handle.");
            try {
                clazz = Class.forName("com.huawei.security.validator.web.DefaultJsonChecker");
                Object jsonCheckerInstance = clazz.newInstance();
                if (jsonCheckerInstance instanceof JsonChecker) {
                    jsonChecker = (JsonChecker)jsonCheckerInstance;
                } else {
                    LOG.error("[WSF-ParamValidate] Can't creat a new json checker instance.");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOG.error(ex.getMessage());
            }
        }
    }
}

