/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.adapter.encryption.dpapi;

import com.huawei.support.icscbb.adapter.encryption.dpapi.DpapiCryptMode;
import com.huawei.support.icscbb.adapter.encryption.dpapi.DpapiException;
import com.huawei.support.icscbb.adapter.encryption.dpapi.DpapiJnaCallResultException;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Dpapi4j {
    private static final SecurityLogUtils SECURITY_LOGGER = SecurityLogUtils.INSTANCE;
    private static boolean IS_WINDOWS_OS = true;
    private final WinKernel32 kernelApi = WinKernel32.INSTANCE;
    private final WinCrypt32 cryptApi = WinCrypt32.INSTANCE;
    private final int cryptMode;

    private static void init() {
        String osName = System.getProperty("os.name");
        IS_WINDOWS_OS = StringUtils.containsIgnoreCase(osName, "windows");
    }

    private Dpapi4j(int modeValue) {
        this.cryptMode = modeValue;
    }

    public static Dpapi4j newInstance(DpapiCryptMode ... cryptModes) throws DpapiException, UnsatisfiedLinkError {
        if (!Dpapi4j.isOsSupported()) {
            throw new DpapiException("Init Dpapi failed. This library works on Windows only.");
        }
        int modeValue = 0;
        for (DpapiCryptMode mode : cryptModes) {
            modeValue |= mode.getMode();
        }
        return new Dpapi4j(modeValue);
    }

    public static boolean isOsSupported() {
        return IS_WINDOWS_OS;
    }

    public static boolean isOsSupported(Dpapi4j dpapi) {
        if (Dpapi4j.isOsSupported() && dpapi != null) {
            return true;
        }
        SECURITY_LOGGER.securityLog("icscbb-adapter", "OS is not windows or missing crypt dll, Dpapi INSTANCE is null.");
        return false;
    }

    public byte[] protectData(byte[] data) throws DpapiException {
        return this.protectData(data, null, null);
    }

    public byte[] protectData(byte[] data, byte[] optionalEntropy) throws DpapiException {
        return this.protectData(data, optionalEntropy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] protectData(byte[] data, byte[] optionalEntropy, String description) throws DpapiException {
        byte[] byArray;
        block8: {
            if (ObjectUtils.isEmpty(data)) {
                throw new DpapiException("Argument data cannot be null");
            }
            WinCrypt32.DataBLOB pbDataIn = new WinCrypt32.DataBLOB(data);
            WinCrypt32.DataBLOB pDataProtected = new WinCrypt32.DataBLOB();
            WinCrypt32.DataBLOB pEntropy = optionalEntropy == null ? null : new WinCrypt32.DataBLOB(optionalEntropy);
            try {
                boolean apiCallSuccess = this.cryptApi.CryptProtectData(pbDataIn, description, pEntropy, null, null, this.cryptMode, pDataProtected);
                if (!apiCallSuccess) {
                    this.raiseJnaCallResultException("ProtectData");
                }
                byArray = pDataProtected.getData();
                if (pDataProtected.pbData == null) break block8;
                this.kernelApi.LocalFree(pDataProtected.pbData);
            }
            catch (Throwable throwable) {
                try {
                    if (pDataProtected.pbData != null) {
                        this.kernelApi.LocalFree(pDataProtected.pbData);
                    }
                    throw throwable;
                }
                catch (DpapiJnaCallResultException e) {
                    throw new DpapiException("Invocation of CryptProtectData failed", e);
                }
            }
        }
        return byArray;
    }

    public byte[] unprotectData(byte[] data) throws DpapiException {
        return this.unprotectData(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unprotectData(byte[] data, byte[] optionalEntropy) throws DpapiException {
        byte[] byArray;
        if (ObjectUtils.isEmpty(data)) {
            throw new DpapiException("Argument data cannot be null");
        }
        WinCrypt32.DataBLOB pDataIn = new WinCrypt32.DataBLOB(data);
        PointerByReference pDescribe = new PointerByReference();
        WinCrypt32.DataBLOB pEntropy = optionalEntropy == null ? null : new WinCrypt32.DataBLOB(optionalEntropy);
        WinCrypt32.DataBLOB pUnprotectedData = new WinCrypt32.DataBLOB();
        try {
            boolean apiCallSuccess = this.cryptApi.CryptUnprotectData(pDataIn, pDescribe, pEntropy, null, null, this.cryptMode, pUnprotectedData);
            if (!apiCallSuccess) {
                this.raiseJnaCallResultException("UnprotectData");
            }
            byArray = pUnprotectedData.getData();
        }
        catch (Throwable throwable) {
            try {
                if (pDescribe.getValue() != null) {
                    this.kernelApi.LocalFree(pDescribe.getValue());
                }
                if (pUnprotectedData.pbData != null) {
                    this.kernelApi.LocalFree(pUnprotectedData.pbData);
                }
                throw throwable;
            }
            catch (DpapiJnaCallResultException e) {
                throw new DpapiException("Invocation of DecryptProtectData failed", e);
            }
        }
        if (pDescribe.getValue() != null) {
            this.kernelApi.LocalFree(pDescribe.getValue());
        }
        if (pUnprotectedData.pbData != null) {
            this.kernelApi.LocalFree(pUnprotectedData.pbData);
        }
        return byArray;
    }

    private void raiseJnaCallResultException(String methodName) throws DpapiJnaCallResultException {
        throw new DpapiJnaCallResultException(String.format(Locale.ENGLISH, "%s JNA call error.", methodName), this.kernelApi.GetLastError());
    }

    private static <T extends Library> T loadNativeLibrary(String name, Class<T> clazz) {
        return (T)Native.load((String)name, clazz, (Map)W32APIOptions.UNICODE_OPTIONS);
    }

    static /* synthetic */ Library access$000(String x0, Class x1) {
        return Dpapi4j.loadNativeLibrary(x0, x1);
    }

    static {
        Dpapi4j.init();
    }

    static interface WinCrypt32
    extends StdCallLibrary {
        public static final WinCrypt32 INSTANCE = (WinCrypt32)Dpapi4j.access$000("Crypt32", WinCrypt32.class);

        public boolean CryptProtectData(DataBLOB var1, String var2, DataBLOB var3, Pointer var4, Pointer var5, int var6, DataBLOB var7);

        public boolean CryptUnprotectData(DataBLOB var1, PointerByReference var2, DataBLOB var3, Pointer var4, Pointer var5, int var6, DataBLOB var7);

        public static class DataBLOB
        extends Structure {
            public Pointer pbData;
            public int cbData;

            DataBLOB() {
            }

            DataBLOB(byte[] data) {
                this.pbData = new Memory((long)data.length);
                this.pbData.write(0L, data, 0, data.length);
                this.cbData = data.length;
                this.allocateMemory();
            }

            protected List<String> getFieldOrder() {
                return Arrays.asList("cbData", "pbData");
            }

            public byte[] getData() {
                byte[] bData = new byte[]{};
                if (this.pbData != null) {
                    bData = this.pbData.getByteArray(0L, this.cbData);
                }
                return bData;
            }
        }
    }

    static interface WinKernel32
    extends StdCallLibrary {
        public static final WinKernel32 INSTANCE = (WinKernel32)Dpapi4j.access$000("Kernel32", WinKernel32.class);

        public Pointer LocalFree(Pointer var1);

        public int GetLastError();
    }
}

