/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.log.common.util;

import com.huawei.it.support.usermanage.helper.UserInfoBean;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.csrf.CsrfToken;

public class HttpUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HttpUtils.class);
    private static final String[] IE_BROWSER_SIGNALS = new String[]{"MSIE", "Trident", "Edge"};

    private HttpUtils() {
    }

    public static String getUserId(HttpServletRequest requestS) {
        if (requestS == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal parameter");
            return "";
        }
        HttpSession sessionS = requestS.getSession(false);
        if (sessionS == null) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "session is null.");
            return "";
        }
        Object objUserInfoBean = sessionS.getAttribute("_SESSION_USER_INFO");
        UserInfoBean userInfoBean = null;
        if (objUserInfoBean instanceof UserInfoBean) {
            userInfoBean = (UserInfoBean)objUserInfoBean;
        }
        if (userInfoBean == null) {
            return "";
        }
        return userInfoBean.getUid();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        if (request == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal parameter");
            return "";
        }
        return request.getRemoteAddr();
    }

    public static String getRemoteHost(HttpServletRequest request) {
        if (request == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal parameter");
            return "";
        }
        return request.getRemoteHost();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean downloadFile(String filename, byte[] block, HttpServletRequest request, HttpServletResponse resp) {
        if (block == null) return false;
        if (block.length == 0) {
            return false;
        }
        String tempFilename = filename;
        resp.reset();
        try (ServletOutputStream out = resp.getOutputStream();){
            String userAgent = request.getHeader("User-Agent");
            if (StringUtils.containsAny((CharSequence)userAgent, "MSIE", "Trident", "Edge")) {
                tempFilename = URLEncoder.encode(tempFilename, StandardCharsets.UTF_8.name());
                tempFilename = tempFilename.replace("+", "%20");
            } else {
                tempFilename = new String(tempFilename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            }
            resp.addHeader("Content-Disposition", "attachment;filename=\"" + tempFilename + "\"");
            resp.addHeader("Content-Length", "" + block.length);
            resp.setContentType("application/octet-stream");
            out.write(block, 0, block.length);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "downloadFile error.");
            resp.setHeader("errorinfo", "file write fail!");
            return false;
        }
    }

    public static String decode(String str) {
        String result = "";
        if (StringUtils.isBlank(str)) {
            return result;
        }
        try {
            str = str.replaceAll("\\+", "%2B");
            result = URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "occur exception", (Throwable)e);
        }
        return result;
    }

    public static String encode(String str) {
        String result = "";
        if (StringUtils.isBlank(str)) {
            return result;
        }
        try {
            result = URLEncoder.encode(str, StandardCharsets.UTF_8.name());
            result = result.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "occur exception", (Throwable)e);
        }
        return result;
    }

    public static String getDomainNameFromRequest(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).append(request.getServletContext().getContextPath()).append("/").toString();
    }

    public static String getContextPath(String originalContextPath) {
        if (StringUtils.isBlank(originalContextPath)) {
            return "";
        }
        int index = (originalContextPath = originalContextPath.substring(1)).indexOf("/");
        return index > -1 ? originalContextPath.substring(0, index) : originalContextPath;
    }

    public static boolean isMSBrowser(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        for (String signal : IE_BROWSER_SIGNALS) {
            if (!userAgent.contains(signal)) continue;
            return true;
        }
        return false;
    }

    public static String getNewContextPath(String icsScene, String contextPath) {
        String newContextPath = contextPath;
        if (StringUtils.isBlank(icsScene)) {
            return newContextPath;
        }
        String[] array = icsScene.split(",");
        List<String> sceneList = null;
        if (array != null && array.length > 0) {
            sceneList = Arrays.asList(array);
        }
        if (sceneList != null && sceneList.size() == 1) {
            if (sceneList.contains("ICSS-Carrier")) {
                newContextPath = "/carrierics";
            } else if (sceneList.contains("ICSS-Enterprise")) {
                newContextPath = "/enterpriseics";
            } else {
                CodeCCUtils.INSTANCE.infoLog(LOG, "the scene not ICSS-Carrier or ICSS-Enterprise");
            }
        }
        return newContextPath;
    }

    public static String getCookieByKey(Cookie[] cookies, String key) {
        String cookieValue = "";
        if (cookies == null || cookies.length == 0) {
            return cookieValue;
        }
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if (!StringUtils.isNotBlank(cookieName) || !cookieName.equals(key)) continue;
            cookieValue = cookie.getValue();
        }
        return cookieValue;
    }

    public static boolean checkParameter(String language, String projectid, String version, String topicId, String topicUrl) {
        return StringUtils.isAnyBlank(language, projectid, version) || StringUtils.isBlank(topicId) && StringUtils.isBlank(topicUrl);
    }

    public static String processingTranscoding(HttpServletRequest request, String str) {
        String tempStr = str;
        try {
            boolean isMsie = HttpUtils.isMSBrowser(request);
            if (isMsie) {
                tempStr = URLEncoder.encode(tempStr, StandardCharsets.UTF_8.name());
                tempStr = tempStr.replace("+", "%20");
            } else {
                tempStr = new String(tempStr.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            }
        }
        catch (UnsupportedEncodingException e1) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Chinese transcoding failed.");
        }
        return tempStr;
    }

    public static String getTokenMetaHtml(HttpServletRequest request) {
        Object objCsrfToken = request.getAttribute("_csrf");
        CsrfToken csrfToken = null;
        if (objCsrfToken instanceof CsrfToken) {
            csrfToken = (CsrfToken)objCsrfToken;
        }
        String tokenVal = "";
        String tokenHeadName = "";
        if (csrfToken != null) {
            tokenVal = csrfToken.getToken();
            tokenHeadName = csrfToken.getHeaderName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("   <meta name=\"_csrf\" content=\"" + tokenVal + "\" />");
        stringBuilder.append("   <meta name=\"_csrf_header\" content=\"" + tokenHeadName + "\" />");
        return stringBuilder.toString();
    }

    public static boolean isUrl(String value) {
        boolean isUrl = true;
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            isUrl = false;
            CodeCCUtils.INSTANCE.errorLog(LOG, "url is not valid.");
        }
        return isUrl;
    }

    public static String getServerAddress() {
        String ipAddress = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ipAddress = inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "unknown host exception occurred.", (Throwable)e);
        }
        return ipAddress;
    }
}

