/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.log.common.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodStackUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodStackUtils.class);
    private static final int GRAND_FATHER_METHOD_DEEP = 3;
    private static final int CURRENT_METHOD_DEEP = 2;
    private static final int CURRENT_ERROR_DEEP = -1;

    private MethodStackUtils() {
    }

    public static String getInvokeMethodName() {
        return MethodStackUtils.getAnyClassMethodName(3);
    }

    public static String getCurrentMethodName() {
        return MethodStackUtils.getAnyClassMethodName(2);
    }

    public static String getAnyClassMethodName(int deep) {
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        if (deep < 0 || deep > stackTrace.length) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal deep number");
            return "";
        }
        if (ArrayUtils.isEmpty(stackTrace)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "empty stackTrace or stack trace too shallow");
            return "";
        }
        return ((StackTraceElement)stackTrace[deep]).getClassName() + "#" + ((StackTraceElement)stackTrace[deep]).getMethodName();
    }

    public static int getAnyMethodLineNumber(int deep) {
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        if (deep < 0 || deep > stackTrace.length) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal deep number");
            return -1;
        }
        if (ArrayUtils.isEmpty(stackTrace)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "empty stackTrace or stack trace too shallow");
            return -1;
        }
        return ((StackTraceElement)stackTrace[deep]).getLineNumber();
    }
}

