/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.cbb.util.address;

import java.text.Normalizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IpUtils {
    private static final int FINALNUMZERO = 0;
    private static final int FINALNUMTHREE = 3;
    private static final int FINALNUMFOUR = 4;
    private static final int FINALNUMFIVE = 5;
    private static final int FINALNUMSEVEN = 7;
    private static final int FINALNUMEIGHT = 8;
    private static final int FINALNUMFIFTEEN = 15;
    private static final int FINALNUMTHIRTYNINE = 39;
    private static final int FINALINTMAX = 255;
    private static final int RESULTFAILED = -1;
    private static final long FINALLONGTWO = 2L;
    private static final long FINALLONGTHREE = 3L;
    private static final String STRUNKNOWN = "unknown";
    private static final String STRCOMMA = ",";
    public static final Pattern IP_PATTERN = Pattern.compile("((25[0-5]|2[0-4]\\d|1?\\d?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1?\\d?\\d)");

    private IpUtils() {
    }

    public static boolean isIpAdress(String ip) {
        if (StringUtils.isBlank(ip)) {
            return false;
        }
        return IP_PATTERN.matcher(ip).matches();
    }

    public static long transIpAdress2Long(String ip) {
        if (!IpUtils.isIpAdress(ip)) {
            return -1L;
        }
        String[] split = ip.split("\\.");
        long trans = 0L;
        for (String part : split) {
            trans = trans << 8 | Long.parseLong(part);
        }
        return trans;
    }

    public static String transLong2IpAdress(long ipNum) {
        StringBuffer ip = new StringBuffer();
        for (int in = 3; in >= 0; --in) {
            ip.append((Object)(ipNum >> 8 * in & 0xFFL));
            if (in == 0) continue;
            ip.append(".");
        }
        return ip.toString();
    }

    public static String getMaxIpByMask(String startIp, int mask) {
        long binaryMask = 3L - (long)mask << 2;
        if (binaryMask != 0L) {
            --binaryMask;
        }
        long maxIp = (IpUtils.transIpAdress2Long(startIp) | binaryMask) - 1L;
        return IpUtils.transLong2IpAdress(maxIp);
    }

    public static String getClientTrueIp(HttpServletRequest request) {
        String ip = request.getHeader("cdn-src-ip");
        if (StringUtils.isBlank(ip) || STRUNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("hwpwuip");
        }
        if (StringUtils.isBlank(ip) || STRUNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (StringUtils.isBlank(ip) || STRUNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || STRUNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || STRUNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("http_client_ip");
        }
        if (StringUtils.isBlank(ip) || STRUNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank(ip) || STRUNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (StringUtils.isNotBlank(ip) && StringUtils.contains((CharSequence)(ip = Normalizer.normalize(ip, Normalizer.Form.NFKC)), STRCOMMA)) {
            ip = ip.substring(0, ip.indexOf(STRCOMMA));
        }
        if (IpUtils.isIpAddress(ip)) {
            return ip;
        }
        return "";
    }

    public static String getClientTrueIp(String allIps) {
        String[] ips;
        if (StringUtils.isBlank(allIps)) {
            return "";
        }
        String realIp = "";
        for (String ip : ips = allIps.split("\\|")) {
            if (!StringUtils.isNotBlank(ip) || StringUtils.equalsIgnoreCase(STRUNKNOWN, ip.trim())) continue;
            realIp = ip.trim();
            break;
        }
        if (StringUtils.isNotBlank(realIp)) {
            if (StringUtils.contains((CharSequence)(realIp = Normalizer.normalize(realIp, Normalizer.Form.NFKC)), STRCOMMA)) {
                realIp = realIp.substring(0, realIp.indexOf(STRCOMMA)).trim();
            }
            if (IpUtils.isIpAdress(realIp)) {
                return realIp.trim();
            }
        }
        return "";
    }

    public static boolean isIpAddress(String ip) {
        if (StringUtils.isBlank(ip)) {
            return false;
        }
        return IpUtils.isIpv4(ip) || IpUtils.isIpv6(ip);
    }

    public static boolean isIpv4(String ip) {
        if (StringUtils.isBlank(ip) || ip.length() < 7 || ip.length() > 15) {
            return false;
        }
        String[] ipNos = ip.split("\\.", -1);
        if (ipNos.length != 4) {
            return false;
        }
        for (String num : ipNos) {
            if (num.length() == 0 || num.length() > 3) {
                return false;
            }
            if (num.charAt(0) == '0' && num.length() != 1) {
                return false;
            }
            for (char ch : num.toCharArray()) {
                if (Character.isDigit(ch)) continue;
                return false;
            }
            if (Integer.parseInt(num) <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isIpv6(String ip) {
        if (StringUtils.isBlank(ip) || ip.length() < 3 || ip.length() > 39) {
            return false;
        }
        String[] ipNos = ip.split(":", -1);
        if (ipNos.length > 8) {
            return false;
        }
        int cmpTime = 0;
        String hexdigits = "0123456789abcdefABCDEF";
        for (String num : ipNos) {
            if (num.length() > 4) {
                return false;
            }
            if (num.length() == 0) {
                ++cmpTime;
                continue;
            }
            if (cmpTime > 1) {
                return false;
            }
            char[] cArray = num.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character ch = Character.valueOf(cArray[i]);
                if (hexdigits.indexOf(ch.charValue()) != -1) continue;
                return false;
            }
        }
        return true;
    }

    public static String getClientUniqueIp(String allIps) {
        if (StringUtils.isBlank(allIps)) {
            return "";
        }
        String[] ips = allIps.split("\\|");
        String forwardedIp = IpUtils.clearIp(ips[0]);
        String cdnSrcIp = "";
        if (ips.length > 1) {
            cdnSrcIp = IpUtils.clearIp(ips[1]);
        }
        String hwPwuIp = "";
        if (ips.length > 5) {
            hwPwuIp = IpUtils.clearIp(ips[5]);
        }
        if (StringUtils.isNotBlank(forwardedIp) || StringUtils.isNotBlank(cdnSrcIp) || StringUtils.isNotBlank(hwPwuIp)) {
            return forwardedIp + "|" + cdnSrcIp + "|" + hwPwuIp;
        }
        return "";
    }

    public static String clearIp(String ipStr) {
        String result = ipStr;
        if (StringUtils.isNotBlank(result) && !StringUtils.equalsIgnoreCase(STRUNKNOWN, result.trim())) {
            result = result.trim();
            if (StringUtils.contains((CharSequence)(result = Normalizer.normalize(result, Normalizer.Form.NFKC)), STRCOMMA)) {
                result = result.substring(0, result.indexOf(STRCOMMA)).trim();
            }
            if (IpUtils.isIpAddress(result)) {
                return result.trim();
            }
        }
        return "";
    }
}

