/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.date;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(DateUtils.class);
    private static final int HOURS = 24;
    private static final int MINUTES = 60;
    private static final int SECONDS = 60;
    private static final int MILLIS = 1000;
    private static final Pattern DAY_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private static final Pattern SECOND_PATTERN = Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}$");
    public static final DateTimeFormatter SECOND_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DAY_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private DateUtils() {
    }

    public static String getCurrentDateStr() {
        return LocalDateTime.now().format(SECOND_TIME_FORMATTER);
    }

    public static long convertStringToLong(String date) {
        long dateMills = 0L;
        if (StringUtils.isBlank(date)) {
            return dateMills;
        }
        LocalDateTime localDateTime = LocalDateTime.parse(date, SECOND_TIME_FORMATTER);
        return localDateTime.toInstant(OffsetDateTime.now(ZoneId.systemDefault()).getOffset()).toEpochMilli();
    }

    public static boolean isValidDate(String dateStr, String pattern) {
        boolean isConvertSuccess = true;
        if (StringUtils.isAnyBlank(dateStr, pattern)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "dateStr or pattern is empty");
            return false;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.setLenient(false);
            format.parse(dateStr);
        }
        catch (ParseException e) {
            isConvertSuccess = false;
        }
        return isConvertSuccess;
    }

    public static long getEndDayTimeStamp() {
        long current = System.currentTimeMillis();
        long zeroT = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        return zeroT + 86400000L - 1L;
    }

    public static Date plusNumDays(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, num);
        return calendar.getTime();
    }

    public static Date plusNumMonths(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, num);
        return calendar.getTime();
    }

    public static Date parseStringToDate(String dateStr, DateTimeFormatter dateTimeFormatter) {
        LocalDate parse = LocalDate.parse(dateStr, dateTimeFormatter);
        return Date.from(parse.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String formatDateToString(Date date, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return dateTimeFormatter.format(localDateTime);
    }

    public static String parseLongToString(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).format(SECOND_TIME_FORMATTER);
    }

    public static boolean isDayFormat(String dateString) {
        return StringUtils.isNotBlank(dateString) && DAY_PATTERN.matcher(dateString).matches();
    }

    public static boolean isSecondFormat(String dateString) {
        return StringUtils.isNotBlank(dateString) && SECOND_PATTERN.matcher(dateString).matches();
    }
}

