/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.file;

import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.util.StreamUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class StreamUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    public static void closeCloseable(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Close closeable exception.");
            }
        }
    }

    public static void closeJarFile(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Close jar file exception.");
            }
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Close writer exception.");
            }
        }
    }

    public static void closeZipFile(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Close zipFile exception.");
            }
        }
    }

    public static byte[] readBytes(InputStream input, long byteCount) {
        byte[] fileBytes = null;
        try {
            fileBytes = StreamUtil.readBytes(input, byteCount);
        }
        catch (ParseRequestDataException | IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "readBytes fail.");
        }
        return fileBytes;
    }
}

