/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.HttpStatusCode;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.dto.HttpHeaderDto;
import com.huawei.support.icscbb.util.http.exception.CustomSslException;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.FragmentDownloadException;
import com.huawei.support.icscbb.util.http.exception.HoupDownloadException;
import com.huawei.support.icscbb.util.http.exception.SupportDownloadException;
import com.huawei.wsf.core.HWDecoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.errors.EncodingException;

public class NetWorkUtil {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(NetWorkUtil.class);
    private static final TypeReference<HashMap<String, String>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, String>>(){};
    private static final int READ_BYTES = 4096;
    private static final int READ_BYTE = -1;
    private static final long HTTP_READTIMEOUT = 10L;
    private static final long HTTP_CONNECTTIMEOUT = 10L;
    private static final long HTTP_WRITETIMEOUT = 10L;
    private static final String UN_LOGIN_ERROR_CODE = "107";
    private static final String HEAD_CONTENT_LENGTH = "Content-Length";
    private static final String HEAD_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String HEAD_ACCEPT_RANGES = "Accept-Ranges";
    private static final String HEAD_CONTENT_RANGE = "Content-Range";
    private static final String HEAD_DOWNLOAD_ERRCODE = "ErrCode";
    private static final String HEAD_ACCEPT_RANGES_BYTES = "bytes";
    private static final String HEAD_RANGE = "range";
    private static final String HEAD_RANGE_VALUE = "bytes=%s-%s";
    private static final String CONTENTTYPE_JSON = "application/json; charset=utf-8";
    private static final List<String> SSL_EXCEPTION_NAMES = Collections.unmodifiableList(Arrays.asList("javax.net.ssl.SSLException", "javax.net.ssl.SSLHandshakeException"));

    private NetWorkUtil() {
    }

    public static String get(HttpClientDto httpClient) throws DownloadException {
        String result;
        block16: {
            result = "";
            try (Response response = NetWorkUtil.assembleDataAndGetResponse(httpClient, false);){
                if (response != null && response.isSuccessful()) {
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        result = responseBody.string();
                    }
                    break block16;
                }
                throw new DownloadException("Get response fail.");
            }
            catch (IOException e) {
                NetWorkUtil.responseExceptionHandler(e);
            }
        }
        return result;
    }

    public static String post(HttpClientDto httpClient) throws DownloadException {
        String result;
        block16: {
            result = "";
            try (Response response = NetWorkUtil.assembleDataAndGetResponse(httpClient, true);){
                if (response != null && response.isSuccessful()) {
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        result = responseBody.string();
                    }
                    break block16;
                }
                throw new DownloadException("Post response fail.");
            }
            catch (IOException e) {
                NetWorkUtil.responseExceptionHandler(e);
            }
        }
        return result;
    }

    private static void responseExceptionHandler(IOException e) {
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "AssembleDataAndGetResponse fail.", (Throwable)e);
        if (SSL_EXCEPTION_NAMES.stream().anyMatch(sslExceptionName -> StringUtils.containsIgnoreCase(e.getClass().getName(), sslExceptionName))) {
            throw new CustomSslException("HTTPS Certificate verification failed.", e);
        }
    }

    public static void getByAsync(HttpClientDto httpClient) {
        if (httpClient == null) {
            return;
        }
        HttpClientDto newClient = NetWorkUtil.setProxy(httpClient);
        OkHttpClient client = newClient.getHttpClient();
        if (client == null) {
            return;
        }
        Request.Builder builder = new Request.Builder().url(newClient.getUrl());
        Headers headers = NetWorkUtil.generateHeaders(newClient.getHeaders());
        builder.headers(headers);
        Request request = builder.build();
        client.newCall(request).enqueue(newClient.getCallback());
    }

    public static void postByAsync(HttpClientDto httpClient) {
        if (httpClient == null) {
            return;
        }
        HttpClientDto newClient = NetWorkUtil.setProxy(httpClient);
        OkHttpClient client = newClient.getHttpClient();
        if (client == null) {
            return;
        }
        Request request = new Request.Builder().url(newClient.getUrl()).post(NetWorkUtil.getBodyFromParam(httpClient)).headers(NetWorkUtil.generateHeaders(newClient.getHeaders())).build();
        client.newCall(request).enqueue(newClient.getCallback());
    }

    public static InputStream getInputStream(HttpClientDto httpClient) throws DownloadException {
        return NetWorkUtil.getResponseByteStream(false, httpClient, false);
    }

    public static InputStream getInputStreamForHoup(HttpClientDto httpClient) throws DownloadException {
        return NetWorkUtil.getResponseByteStream(false, httpClient, true);
    }

    public static boolean writeFile(String saveDir, String fileName, InputStream inputStream) {
        String savePath;
        byte[] bytes = new byte[4096];
        try {
            savePath = NetWorkUtil.getDownloadSaveDir(saveDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, e.getMessage());
            return Boolean.FALSE;
        }
        String filePath = savePath + File.separator + fileName;
        File file = FileUtils.getFile(filePath);
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);){
            int len = inputStream.read(bytes);
            while (len != -1) {
                fileOutputStream.write(bytes, 0, len);
                len = inputStream.read(bytes);
            }
            fileOutputStream.flush();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Write file error, the file path is {0}", filePath);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String getDownloadSaveDir(String saveDir) throws IOException {
        File downloadFile = FileUtils.getFile(saveDir);
        if (!downloadFile.exists() && !downloadFile.mkdirs()) {
            throw new IOException("Create new directory failed.");
        }
        return downloadFile.getCanonicalPath();
    }

    public static InputStream getSplitInputStream(HttpClientDto httpClient) throws DownloadException {
        HttpClientDto newHttpClient = NetWorkUtil.setRangeToHeaders(httpClient);
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "getSplitIS start");
        return NetWorkUtil.getResponseByteStream(true, newHttpClient, false);
    }

    public static InputStream getSplitInputStreamForHoup(HttpClientDto httpClient) throws DownloadException {
        HttpClientDto newHttpClient = NetWorkUtil.setRangeToHeaders(httpClient);
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "getSplitIS start");
        return NetWorkUtil.getResponseByteStream(true, newHttpClient, true);
    }

    public static void getSplitInputStreamByAsync(HttpClientDto httpClient) throws DownloadException {
        HttpClientDto newHttpClient = NetWorkUtil.setRangeToHeaders(httpClient);
        NetWorkUtil.checkFragmentDownloadLink(newHttpClient);
        NetWorkUtil.getByAsync(newHttpClient);
    }

    public static HttpHeaderDto getHeadersForHoup(HttpClientDto httpClient) {
        return NetWorkUtil.getHttpHeaderDto(httpClient, true);
    }

    public static HttpHeaderDto getHeaders(HttpClientDto httpClient) {
        return NetWorkUtil.getHttpHeaderDto(httpClient, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpHeaderDto getHttpHeaderDto(HttpClientDto httpClient, boolean isHoup) {
        HttpHeaderDto httpHeader = null;
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "getHeaders start");
        try (Response response = NetWorkUtil.assembleDataAndGetHead(httpClient);){
            if (response == null) {
                HttpHeaderDto httpHeaderDto = httpHeader;
                return httpHeaderDto;
            }
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "getHeaders response code:" + response.code());
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "after getHeaders request method:" + response.request().method());
            Headers headers = response.headers();
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "after getHeads response request-headers:" + response.request().headers().toString());
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "after getHeaders response headers:" + headers.toString());
            String sizeStr = NetWorkUtil.getFileSizeByRange(headers);
            String fileName = NetWorkUtil.processFileName(headers.get(HEAD_CONTENT_DISPOSITION));
            String errCode = isHoup ? NetWorkUtil.getErrorCodeFromHoupResponse(response) : NetWorkUtil.getErrorCodeFromResponse(response);
            if (StringUtils.isNotBlank(errCode)) {
                sizeStr = "";
            }
            boolean isFragmentDownloadLink = true;
            try {
                NetWorkUtil.checkHeaders(response);
            }
            catch (DownloadException e) {
                isFragmentDownloadLink = false;
            }
            httpHeader = new HttpHeaderDto().setSize(StringUtils.isBlank(sizeStr) ? 0L : Long.parseLong(sizeStr)).setFileName(fileName).setErrCode(errCode).setFragmentDownloadLink(isFragmentDownloadLink).setHeaders(headers);
            return httpHeader;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "AssembleDataAndGetHead fail", (Throwable)e);
        }
        return httpHeader;
    }

    private static String getErrorCodeFromHoupResponse(Response response) throws IOException {
        if (response.isSuccessful()) {
            return "";
        }
        return NetWorkUtil.isLoginError(response) ? UN_LOGIN_ERROR_CODE : String.valueOf(response.code());
    }

    private static boolean isLoginError(Response response) throws IOException {
        if (response.code() == HttpStatusCode.HTTP_STATUS_CODE_401.getCode() && Objects.nonNull(response.body())) {
            String bodyStr = response.body().string();
            Map responseMap = JSONObject.parseObject(bodyStr, MAP_TYPE_REFERENCE, new Feature[0]);
            return MapUtils.isNotEmpty(responseMap) && StringUtils.equals((CharSequence)responseMap.get("errorCode"), UN_LOGIN_ERROR_CODE);
        }
        return false;
    }

    private static String getErrorCodeFromResponse(Response response) {
        if (response == null) {
            return "";
        }
        int times = 6;
        int index = 0;
        String errCode = "";
        for (Response priorRes = response; index < times && StringUtils.isBlank(errCode) && priorRes != null; priorRes = priorRes.priorResponse(), ++index) {
            errCode = NetWorkUtil.getSupportDownloadErrCode(priorRes.headers());
        }
        if (StringUtils.isNotBlank(errCode)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "check [{0}] times and find error code [{1}]", index, errCode);
        } else if (index == times) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "check [{0}] times but didn't find any error code", times);
        }
        return errCode;
    }

    private static String getSupportDownloadErrCode(Headers headers) {
        String errCode = headers.get(HEAD_DOWNLOAD_ERRCODE);
        return Optional.ofNullable(errCode).orElse("");
    }

    private static String getFileSizeByRange(Headers headers) {
        String sizeStr = headers.get(HEAD_CONTENT_LENGTH);
        String rang = Optional.ofNullable(headers.get(HEAD_CONTENT_RANGE)).orElse("");
        int index = rang.lastIndexOf("/");
        if (StringUtils.isNotBlank(rang) && index > 0 && index + 1 < rang.length()) {
            sizeStr = rang.substring(index + 1);
        }
        return sizeStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getDownloadSize(HttpClientDto httpClient) {
        long size = 0L;
        Map headers = Optional.ofNullable(httpClient.getHeaders()).orElse(new HashMap());
        headers.put(HEAD_RANGE, String.format(Locale.ENGLISH, HEAD_RANGE_VALUE, 0, 0));
        httpClient.newBuilder().headers(headers);
        try (Response response = NetWorkUtil.assembleDataAndGetResponse(httpClient, false);){
            if (response == null) {
                Long l = size;
                return l;
            }
            String contentRange = response.header(HEAD_CONTENT_RANGE);
            String sizeStr = StringUtils.isBlank(contentRange) || contentRange.indexOf("/") <= 0 || contentRange.indexOf("/") >= contentRange.length() - 1 ? response.header(HEAD_CONTENT_LENGTH) : contentRange.substring(contentRange.indexOf("/") + 1);
            size = StringUtils.isBlank(sizeStr) ? size : Long.parseLong(sizeStr);
            return size;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "AssembleDataAndGetResponse fail.", (Throwable)e);
        }
        return size;
    }

    public static String getDownloadName(HttpClientDto httpClient) {
        httpClient.getHeaders().put(HEAD_RANGE, String.format(Locale.ENGLISH, HEAD_RANGE_VALUE, 0, 0));
        String fileName = NetWorkUtil.getHeadValueByName(HEAD_CONTENT_DISPOSITION, httpClient);
        return NetWorkUtil.processFileName(fileName);
    }

    public static String getDownloadNameByUrl(String paramUrl) {
        String fileName = "";
        String url = paramUrl;
        try {
            URL urlDo;
            String path;
            if (!url.startsWith("http://") || !url.startsWith("https://")) {
                url = "http://" + url;
            }
            if (StringUtils.isNotBlank(path = (urlDo = new URL(url)).getPath())) {
                fileName = path.substring(path.lastIndexOf("/") + 1);
            }
        }
        catch (MalformedURLException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Failed to convert the URL.");
        }
        return fileName;
    }

    public static String getHeadValueByName(String key, HttpClientDto httpClient) {
        String value = "";
        try (Response response = NetWorkUtil.assembleDataAndGetHead(httpClient);){
            if (response != null) {
                value = response.header(key);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "AssembleDataAndGetHead fail.", (Throwable)e);
        }
        return value;
    }

    public static OkHttpClient setDefaultHttpSetting(OkHttpClient okHttpClient) {
        if (okHttpClient == null) {
            return okHttpClient;
        }
        return okHttpClient.newBuilder().readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).connectTimeout(10L, TimeUnit.SECONDS).build();
    }

    private static InputStream getResponseByteStream(boolean isSplit, HttpClientDto httpClient, boolean isHoup) throws DownloadException {
        try {
            Response response = NetWorkUtil.assembleDataAndGetResponse(httpClient, false);
            if (response == null) {
                return null;
            }
            CodeCCUtils.INSTANCE.infoLog(LOGGER, " after getSplitIS-response request-method:" + response.request().method());
            CodeCCUtils.INSTANCE.infoLog(LOGGER, " after getSplitIS-response request-code:" + response.code());
            CodeCCUtils.INSTANCE.infoLog(LOGGER, " after getSplitIS-response request-headers:" + response.request().headers());
            CodeCCUtils.INSTANCE.infoLog(LOGGER, " after getSplitIS-response headers:" + response.headers());
            if (isHoup) {
                NetWorkUtil.handlerHoupErrorCode(response);
            } else {
                NetWorkUtil.checkPriorResponseHeaders(response);
            }
            if (isSplit) {
                NetWorkUtil.checkHeaders(response);
            }
            return response.body().byteStream();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "AssembleDataAndGetResponse fail.", (Throwable)e);
            return null;
        }
    }

    private static Response assembleDataAndGetResponse(HttpClientDto httpClient, boolean isPost) throws IOException {
        if (httpClient == null) {
            return null;
        }
        HttpClientDto newClient = NetWorkUtil.setProxy(httpClient);
        OkHttpClient client = newClient.getHttpClient();
        if (client == null) {
            return null;
        }
        Request.Builder builder = new Request.Builder().url(newClient.getUrl());
        if (isPost) {
            RequestBody body = NetWorkUtil.getBodyFromParam(httpClient);
            builder.post(body);
        }
        Headers headers = NetWorkUtil.generateHeaders(newClient.getHeaders());
        builder.headers(headers);
        Request request = builder.build();
        CodeCCUtils.INSTANCE.infoLog(LOGGER, " before getSplitIS-response request-method:" + request.method());
        CodeCCUtils.INSTANCE.infoLog(LOGGER, " before getSplitIS-response request-header:" + request.headers());
        return client.newCall(request).execute();
    }

    private static Response assembleDataAndGetHead(HttpClientDto httpClient) throws IOException {
        if (httpClient == null) {
            return null;
        }
        HttpClientDto newClient = NetWorkUtil.setProxy(httpClient);
        OkHttpClient client = newClient.getHttpClient();
        if (client == null) {
            return null;
        }
        Request.Builder builder = new Request.Builder().head().url(newClient.getUrl());
        Headers headers = NetWorkUtil.generateHeaders(newClient.getHeaders());
        builder.headers(headers);
        Request request = builder.build();
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "before getHead request method:" + request.method());
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "before getHead request headers:" + request.headers().toString());
        return client.newCall(request).execute();
    }

    private static RequestBody getBodyFromParam(HttpClientDto httpClient) {
        String contentType = httpClient.getMediaType();
        if (StringUtils.isBlank(httpClient.getMediaType())) {
            contentType = CONTENTTYPE_JSON;
        }
        return RequestBody.Companion.create(NetWorkUtil.getBodyJson(httpClient), MediaType.parse((String)contentType));
    }

    private static String getBodyJson(HttpClientDto httpClient) {
        if (StringUtils.isNotBlank(httpClient.getBody())) {
            return httpClient.getBody();
        }
        Map<String, String> params = httpClient.getParams();
        if (MapUtils.isNotEmpty(params)) {
            return JSON.toJSONString(params);
        }
        return "";
    }

    private static void checkFragmentDownloadLink(HttpClientDto httpClient) throws DownloadException {
        try (Response response = NetWorkUtil.assembleDataAndGetResponse(httpClient, false);){
            if (response != null) {
                NetWorkUtil.checkHeaders(response);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "AssembleDataAndGetResponse fail.", (Throwable)e);
        }
    }

    private static void checkHeaders(Response response) throws DownloadException {
        String acceptRanges = response.header(HEAD_ACCEPT_RANGES);
        String contentRange = response.header(HEAD_CONTENT_RANGE);
        if (StringUtils.isNotBlank(contentRange) || StringUtils.equalsIgnoreCase(acceptRanges, HEAD_ACCEPT_RANGES_BYTES)) {
            return;
        }
        response.close();
        throw new FragmentDownloadException("The resource does not support segment download.");
    }

    private static void checkPriorResponseHeaders(Response response) throws DownloadException {
        Response priorRes = response.priorResponse();
        String errCode = "";
        if (priorRes != null) {
            errCode = NetWorkUtil.getSupportDownloadErrCode(priorRes.headers());
        }
        if (StringUtils.isBlank(errCode)) {
            return;
        }
        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Has support error code, code is {0}", errCode);
        response.close();
        throw new SupportDownloadException(errCode);
    }

    private static void handlerHoupErrorCode(Response response) throws DownloadException, IOException {
        String errorCode;
        if (response.isSuccessful()) {
            return;
        }
        String string = errorCode = NetWorkUtil.isLoginError(response) ? UN_LOGIN_ERROR_CODE : String.valueOf(response.code());
        if (StringUtils.isNotBlank(errorCode)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Has houp error code, code is {0}", errorCode);
            response.close();
            throw new HoupDownloadException(errorCode);
        }
    }

    private static HttpClientDto setProxy(HttpClientDto httpClient) {
        if (httpClient == null) {
            return httpClient;
        }
        String host = httpClient.getProxyHost();
        String port = httpClient.getProxyPort();
        final String userName = httpClient.getProxyUserName();
        final String password = httpClient.getProxyPassword();
        OkHttpClient client = httpClient.getHttpClient();
        if (client == null || StringUtils.isAnyBlank(host, port)) {
            return httpClient;
        }
        OkHttpClient.Builder builder = client.newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, Integer.parseInt(port))));
        if (!StringUtils.isAllBlank(userName, password)) {
            builder.proxyAuthenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) {
                    String credential = Credentials.basic((String)userName, (String)password);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            });
        }
        return httpClient.newBuilder().httpClient(builder.build()).build();
    }

    private static Headers generateHeaders(Map<String, String> params) {
        Headers.Builder builder = new Headers.Builder();
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> it : params.entrySet()) {
                builder.add(it.getKey(), it.getValue());
            }
        }
        return builder.build();
    }

    private static HttpClientDto setRangeToHeaders(HttpClientDto httpClient) {
        if (httpClient == null) {
            return httpClient;
        }
        Map<String, String> mapHeaders = httpClient.getHeaders();
        if (MapUtils.isEmpty(mapHeaders)) {
            mapHeaders = new HashMap<String, String>();
        }
        mapHeaders.put(HEAD_RANGE, String.format(Locale.ENGLISH, HEAD_RANGE_VALUE, httpClient.getStartPos(), httpClient.getEndPos()));
        return httpClient.newBuilder().headers(mapHeaders).build();
    }

    private static String processFileName(String fileName) {
        String name = "";
        if (StringUtils.isBlank(fileName)) {
            return name;
        }
        String[] split = fileName.split(";");
        String key = "filename=\"";
        for (String str : split) {
            String newStr = str.trim();
            if (!newStr.contains(key)) continue;
            name = newStr.substring(newStr.indexOf(key) + key.length(), newStr.lastIndexOf("\""));
            break;
        }
        try {
            name = HWDecoder.decodeFromURL(name, "utf-8");
        }
        catch (EncodingException e) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "decode fileName fail.", (Throwable)e);
        }
        return name;
    }
}

