/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.http;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class UrlParamUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UrlParamUtils.class);
    private static final String QUESTION_MARK = "?";
    private static final String QUESTION_MARK_PATTERN = "\\?";
    private static final String EQUAL_MARK = "=";
    private static final String AND_MARK = "&";

    private UrlParamUtils() {
    }

    public static UrlDto parse(String url) {
        UrlDto entity = new UrlDto();
        if (StringUtils.isBlank(url)) {
            return entity;
        }
        String path = url.trim();
        String[] urlParts = path.split(QUESTION_MARK_PATTERN);
        if (ArrayUtils.isNotEmpty(urlParts)) {
            entity.setBaseUrl(urlParts[0]);
        }
        if (urlParts.length == 1) {
            return entity;
        }
        String[] params = urlParts[1].split(AND_MARK);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        entity.params = new HashMap();
        for (String param : params) {
            String[] keyValue = param.split(EQUAL_MARK);
            if (keyValue.length <= 1) {
                paramMap.put(keyValue[0], "");
                continue;
            }
            paramMap.put(keyValue[0], keyValue[1]);
        }
        entity.setParams(paramMap);
        return entity;
    }

    public static String encodeUrl(String param) {
        String encode = null;
        try {
            encode = URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "encodeUrl error.", (Throwable)e);
        }
        return encode;
    }

    public static class UrlDto {
        private String baseUrl;
        private Map<String, String> params;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }
    }
}

