/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.image;

import com.google.common.collect.Maps;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(ImageUtils.class);

    private ImageUtils() {
    }

    public static Map<String, Integer> getImageHeightAndWidth(File file) {
        HashMap highAndWidth = Maps.newHashMap();
        if (file == null || !file.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "file is empty");
            return highAndWidth;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return highAndWidth;
            }
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            highAndWidth.put("width", width);
            highAndWidth.put("height", height);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "IOException");
        }
        return highAndWidth;
    }
}

