/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BasePool<T> {
    protected Map<String, T> objectMap = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, false));

    protected abstract void createPool(String var1);

    protected void addPool(String key, T object) {
        this.objectMap.put(key, object);
    }

    protected T delPool(String key) {
        return this.objectMap.remove(key);
    }

    protected T delfirstPool() {
        T object;
        block0: {
            object = null;
            Iterator<String> iterator = this.objectMap.keySet().iterator();
            if (!iterator.hasNext()) break block0;
            String key = iterator.next();
            object = this.objectMap.remove(key);
        }
        return object;
    }

    protected void checkPool(int max) {
        while (this.objectMap.size() > max) {
            this.delfirstPool();
        }
    }

    public int poolSize() {
        return this.objectMap.size();
    }

    public T getPool(String key) {
        T object = this.objectMap.get(key);
        if (object == null) {
            this.createPool(key);
            object = this.objectMap.get(key);
        }
        return object;
    }

    public List<T> getAllPool(int start, int len) {
        ArrayList pool = new ArrayList();
        ArrayList<T> objectMapList = new ArrayList<T>(this.objectMap.values());
        int times = 0;
        for (Object t : objectMapList) {
            if (times >= start && times < start + len) {
                pool.add(t);
            }
            if (++times < start + len) continue;
            break;
        }
        return pool;
    }
}

