/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.pool;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.zipfile.ZipFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ZipFilePool {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(ZipFilePool.class);
    private static final int MAX = 100;
    private static final Object LOCK = new Object();
    private static final Map<String, ZipFile> ZIP_FILE_POOL = Collections.synchronizedMap(new LinkedHashMap(100, 0.75f, true));

    private ZipFilePool() {
    }

    public static InputStream getInputStream(String docPath, String path) throws IOException {
        if (StringUtils.isAnyBlank(docPath, path)) {
            return null;
        }
        ZipFile zipFile = ZipFilePool.getZipFile(docPath, ZipFilePool.getCharset(docPath));
        return ZipFileUtil.getInputStream(zipFile, path);
    }

    private static Charset getCharset(String docPath) {
        if (StringUtils.endsWithIgnoreCase(docPath, ".hdx")) {
            return StandardCharsets.UTF_8;
        }
        if (StringUtils.endsWithIgnoreCase(docPath, ".hwics")) {
            return Charset.forName("GBK");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFile getZipFile(String key, Charset charset) {
        if (StringUtils.isBlank(key)) {
            return null;
        }
        if (ZIP_FILE_POOL.get(key) == null) {
            Object object = LOCK;
            synchronized (object) {
                if (ZIP_FILE_POOL.get(key) == null) {
                    try {
                        ZipFile zipFile = ZipFilePool.createZipFile(key, charset);
                        if (zipFile == null) {
                            return null;
                        }
                        ZIP_FILE_POOL.put(key, zipFile);
                        if (ZIP_FILE_POOL.size() > 100) {
                            ZipFilePool.removeAndClose(ZIP_FILE_POOL.entrySet().iterator().next().getKey());
                        }
                    }
                    catch (IOException e) {
                        CodeCCUtils.INSTANCE.errorLog(LOG, "create ZipFile error", (Throwable)e);
                    }
                }
            }
        }
        return ZIP_FILE_POOL.get(key);
    }

    private static ZipFile createZipFile(String key, Charset charset) throws IOException {
        File file = FileUtils.getFile(key);
        if (!file.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, " ZipFile not exits");
            return null;
        }
        if (charset == null) {
            return new ZipFile(file);
        }
        return new ZipFile(file, charset);
    }

    public static void removeAndClose(String key) {
        if (StringUtils.isBlank(key)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipPool key is blank");
            return;
        }
        ZipFile zipFile = ZIP_FILE_POOL.remove(key);
        if (zipFile == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipPool key's value is null");
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "close zipFile error, path:", zipFile.getName());
        }
    }
}

