/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.properties;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class PropertiesUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(PropertiesUtils.class);

    private PropertiesUtils() {
    }

    public static String getPropertyValue(String propertiesFileName, String keyName) {
        Optional<Properties> propertiesOptional = PropertiesUtils.getPropertiesByFileName(propertiesFileName);
        if (!propertiesOptional.isPresent()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Properties optional is null.");
            return "";
        }
        return propertiesOptional.get().getProperty(keyName);
    }

    public static Optional<Properties> getPropertiesByFileName(String fileName) {
        File propertiesFile = FileUtils.getFile(fileName);
        if (propertiesFile == null || !propertiesFile.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Properties file is null or does not exist.");
            return Optional.empty();
        }
        Properties properties = PropertiesUtils.getPropertiesByFile(propertiesFile);
        if (properties == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Properties load failed.");
            return Optional.empty();
        }
        return Optional.of(properties);
    }

    public static Properties getPropertiesByFile(File file) {
        Properties props = new Properties();
        if (PropertiesUtils.setPropertyFromFile(props, file)) {
            return null;
        }
        return props;
    }

    public static Properties getPropertiesByResourceName(String resourceName) {
        Properties properties = new Properties();
        try (InputStream resourceAsStream = PropertiesUtils.class.getClassLoader().getResourceAsStream(resourceName);){
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, String.format(Locale.ENGLISH, "%s:getPropertiesByName IOException", resourceName));
        }
        return properties;
    }

    public static boolean storeProperties(Properties properties, String filePath) {
        try (FileOutputStream outputStream = FileUtils.openOutputStream(FileUtils.getFile(filePath));){
            properties.store(outputStream, "storeProperties");
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "storeProperties write failed.");
            return false;
        }
        return true;
    }

    public static boolean setPropertyFromFile(Properties props, File file) {
        try (FileInputStream property = FileUtils.openInputStream(file);){
            props.load(property);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "GET property error.");
            return true;
        }
        return false;
    }
}

