/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.thread;

import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icscbb.util.thread.ThreadUncaughtExceptionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class CompletableFutureTimeout {
    public static <T> CompletableFuture<T> completeOnTimeout(T t, CompletableFuture<T> future, long timeout, TimeUnit unit) {
        CompletableFuture<T> timeoutFuture = CompletableFutureTimeout.timeoutAfter(timeout, unit);
        return ((CompletableFuture)future.applyToEither((CompletionStage)timeoutFuture, Function.identity())).exceptionally(throwable -> t);
    }

    public static <T> CompletableFuture<T> orTimeout(T t, CompletableFuture<T> future, long timeout, TimeUnit unit) {
        CompletableFuture<T> timeoutFuture = CompletableFutureTimeout.timeoutAfter(timeout, unit);
        return ((CompletableFuture)future.applyToEither((CompletionStage)timeoutFuture, Function.identity())).exceptionally(throwable -> t);
    }

    private static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        Delayer.POOL_EXECUTOR.schedule(() -> result.completeExceptionally(new TimeoutException()), timeout, unit);
        return result;
    }

    private static final class Delayer {
        private static final ScheduledThreadPoolExecutor POOL_EXECUTOR = ThreadPoolFactory.getScheduleThreadPoolExecutor(1, new DaemonThreadFactory());

        private Delayer() {
        }

        static {
            POOL_EXECUTOR.setRemoveOnCancelPolicy(true);
        }

        private static final class DaemonThreadFactory
        implements ThreadFactory {
            private DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setUncaughtExceptionHandler(new ThreadUncaughtExceptionHandler());
                thread.setDaemon(true);
                thread.setName("CompletableFutureDelayScheduler");
                return thread;
            }
        }
    }
}

