/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.thread;

import com.huawei.support.icscbb.util.thread.NamedThreadFactory;
import com.huawei.support.icscbb.util.thread.ScheduleExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolFactory {
    private static final Map<String, ThreadPoolExecutor> THREAD_MAP = new ConcurrentHashMap<String, ThreadPoolExecutor>(16);

    private ThreadPoolFactory() {
    }

    public static ThreadPoolExecutor getThreadPool(String name, int corePoolSize, int keepAliveSeconds, int maxPoolSize, int queueCapacity) {
        if (!THREAD_MAP.containsKey(name)) {
            ThreadPoolExecutor poolTaskExecutor = ThreadPoolFactory.createThreadExecutor(corePoolSize, maxPoolSize, keepAliveSeconds, queueCapacity, name + "-");
            THREAD_MAP.putIfAbsent(name, poolTaskExecutor);
        }
        return THREAD_MAP.get(name);
    }

    public static ScheduledThreadPoolExecutor getScheduleThreadPoolExecutor() {
        return ScheduleExecutor.INSTANCE.getThreadPoolExecutor();
    }

    public static ScheduledThreadPoolExecutor getScheduleThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    private static ThreadPoolExecutor createThreadExecutor(int corePoolSize, int maxPoolSize, int keepAliveSeconds, int queueCapacity, String threadNamePrefix) {
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, (long)keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(threadNamePrefix));
    }
}

