/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.zipfile;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ZipFileUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ZipFileUtils.class);
    private static final Integer BUFFER_SIZE = 1024;
    private static final String CLOSE_BY_INTERRAPTION = "ClosedByInterruptException";
    private static final String FILE_NAME_CROSS_DIEECTOR_LINUX = "../";
    private static final String FILE_NAME_CROSS_DIEECTOR_WIN = "..\\";
    private static final int EOF = -1;
    private static final int BYTE_LENGTH = 4096;
    private static final String SEPARATOR = "/";
    private static final String GBK = "GBK";
    private static final int MAX_FILE_NUM = 500000;
    private static final long MAX_SINGLE_SIZE = 0x80000000L;
    private static final int SKIP_THIS_FILE = -122312;
    private static final long MAX_TOTAL_SIZE = 0x140000000L;

    private ZipFileUtils() {
    }

    public static ZipFile createZipFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return new ZipFile(file, GBK);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "CreateZipFile error, IOException.");
            return null;
        }
    }

    public static ZipArchiveEntry getZipEntry(ZipFile zipFile, String filePath) {
        ZipArchiveEntry zipArchiveEntry;
        if (zipFile == null) {
            return null;
        }
        String termFilePath = filePath;
        if (StringUtils.isNotEmpty(termFilePath)) {
            termFilePath = termFilePath.replaceAll("\\\\", "\\/");
        }
        if ((zipArchiveEntry = zipFile.getEntry(termFilePath)) == null || zipArchiveEntry.getCompressedSize() == 0L) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Read zip file not exist.");
            return null;
        }
        return zipArchiveEntry;
    }

    public static InputStream getInput(ZipFile zipFile, String filePath) {
        if (zipFile == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get Input error,zipFile null.");
            return null;
        }
        if (StringUtils.isBlank(filePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "filePath is empty.");
            return null;
        }
        ZipArchiveEntry entry = ZipFileUtils.getZipEntry(zipFile, filePath);
        if (entry == null && (entry = ZipFileUtils.getZipEntry(zipFile, filePath.toLowerCase(Locale.ENGLISH))) == null) {
            return null;
        }
        try {
            return zipFile.getInputStream(entry);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "ZipFileUtils getInput IO error.");
            return null;
        }
    }

    public static void readContent(ZipFile zipFile, String filePath, OutputStream ops) {
        if (zipFile == null || StringUtils.isBlank(filePath)) {
            return;
        }
        ZipArchiveEntry zipEntry = ZipFileUtils.getZipEntry(zipFile, filePath);
        if (zipEntry == null || zipEntry.getCompressedSize() == 0L) {
            return;
        }
        try (InputStream fis = zipFile.getInputStream(zipEntry);){
            int len;
            if (fis == null) {
                return;
            }
            long totalByte = 0L;
            byte[] buffer = new byte[BUFFER_SIZE.intValue()];
            while ((len = fis.read(buffer)) != -1) {
                if ((totalByte += (long)len) > 0x80000000L) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "Zip file is too big, exceed 2147483648bytes limit");
                    break;
                }
                ops.write(buffer, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "File not found Exception.");
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, " Error read file, IOException.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readContent(ZipFile zipFile, String filePath) {
        if (zipFile == null) return null;
        if (StringUtils.isBlank(filePath)) {
            return null;
        }
        ZipArchiveEntry zipEntry = ZipFileUtils.getZipEntry(zipFile, filePath);
        if (zipEntry == null) return null;
        if (zipEntry.getCompressedSize() == 0L) {
            return null;
        }
        try (InputStream fis = zipFile.getInputStream(zipEntry);){
            if (fis == null) return null;
            byte[] byArray = IOUtils.toByteArray(fis);
            return byArray;
        }
        catch (FileNotFoundException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "File not found Exception.");
            return null;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Error read file, IOException.");
        }
        return null;
    }

    public static boolean isCheckFileName(String fileName, List<String> unzipFileTypes) {
        if (StringUtils.isBlank(fileName) || StringUtils.contains((CharSequence)fileName, FILE_NAME_CROSS_DIEECTOR_LINUX) || StringUtils.contains((CharSequence)fileName, FILE_NAME_CROSS_DIEECTOR_WIN)) {
            return false;
        }
        if (CollectionUtils.isEmpty(unzipFileTypes)) {
            return true;
        }
        if (!StringUtils.contains((CharSequence)fileName, ".")) {
            return false;
        }
        String fileSuffix = fileName.substring(fileName.lastIndexOf("."));
        return StringUtils.isNotBlank(fileSuffix) && unzipFileTypes.contains(fileSuffix.toLowerCase(Locale.ENGLISH));
    }

    public static boolean unZip(String zipFilePath, String destDirPath) {
        boolean isUnZipSuccess;
        try (ZipFile zipFile = ZipFileUtils.createZipFile(FileUtils.getFile(zipFilePath));){
            isUnZipSuccess = ZipFileUtils.beginToUnzip(zipFile, destDirPath);
        }
        catch (IOException e) {
            isUnZipSuccess = false;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "unzip process exception.");
        }
        return isUnZipSuccess;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean beginToUnzip(ZipFile zipFile, String destDirPath) throws IOException {
        fileNum = 0;
        total = 0L;
        if (zipFile == null) {
            CodeCCUtils.INSTANCE.errorLog(ZipFileUtils.LOGGER, "zipFile is null");
            return false;
        }
        entries = zipFile.getEntries();
        while (entries.hasMoreElements() != false) {
            entry = (ZipArchiveEntry)entries.nextElement();
            zis = zipFile.getInputStream(entry);
            var8_7 = null;
            try {
                block51: {
                    block52: {
                        block49: {
                            block50: {
                                if (zis == null) continue;
                                if (entry.isDirectory()) {
                                    ZipFileUtils.checkDestDir(destDirPath);
                                    continue;
                                }
                                validPath = ZipFileUtils.sanitzeFileName(entry.getName(), destDirPath);
                                try {
                                    fos = FileUtils.openOutputStream(FileUtils.getFile(new String[]{validPath}));
                                    var11_15 = null;
                                    try {
                                        bytes = new byte[4096];
                                        len = zis.read(bytes, 0, 4096);
lbl23:
                                        // 2 sources

                                        while (len != -1) {
                                            if ((total += (long)len) > 0x80000000L) {
                                                CodeCCUtils.INSTANCE.errorLog(ZipFileUtils.LOGGER, "File being unzipped is too big.");
                                                var14_22 = false;
                                                if (fos == null) return var14_22;
                                                if (var11_15 == null) break block49;
                                                break block50;
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        ** GOTO lbl54
                                    }
                                    catch (Throwable var12_19) {
                                        var11_15 = var12_19;
                                        throw var12_19;
                                    }
                                }
                                catch (IOException e) {
                                    CodeCCUtils.INSTANCE.errorLog(ZipFileUtils.LOGGER, "Unzip error.");
                                    var11_16 = false;
                                    return var11_16;
                                }
                                catch (Throwable var16_28) {
                                    throw var16_28;
                                }
                            }
                            try {
                                fos.close();
                                return var14_22;
                            }
                            catch (Throwable var15_24) {
                                var11_15.addSuppressed(var15_24);
                                return var14_22;
                            }
                        }
                        fos.close();
                        return var14_22;
lbl-1000:
                        // 1 sources

                        {
                            fos.write(bytes, 0, len);
                            len = zis.read(bytes, 0, 4096);
                            ** GOTO lbl23
lbl54:
                            // 1 sources

                            if (!FileUtils.getFile(new String[]{validPath}).setLastModified(entry.getTime())) {
                                CodeCCUtils.INSTANCE.infoLog(ZipFileUtils.LOGGER, "Files keep self lastModified time fail when unzip.");
                            }
                            if (++fileNum <= 500000) break block51;
                            CodeCCUtils.INSTANCE.errorLog(ZipFileUtils.LOGGER, "Too many files to unzip.");
                            var14_23 = false;
                            if (fos == null) return var14_23;
                            if (var11_15 == null) break block52;
                        }
                        try {
                            fos.close();
                            return var14_23;
                        }
                        catch (Throwable var15_26) {
                            var11_15.addSuppressed(var15_26);
                            return var14_23;
                        }
                    }
                    fos.close();
                    return var14_23;
                }
                ** try [egrp 15[TRYBLOCK] [9, 12 : 475->480)] { 
lbl72:
                // 1 sources

                fos.flush();
                continue;
lbl74:
                // 1 sources

                finally {
                    if (fos == null) continue;
                    if (var11_15 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable var12_18) {
                            var11_15.addSuppressed(var12_18);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            catch (Throwable var9_12) {
                var8_7 = var9_12;
                throw var9_12;
            }
            finally {
                if (zis == null) continue;
                if (var8_7 != null) {
                    try {
                        zis.close();
                    }
                    catch (Throwable var9_9) {
                        var8_7.addSuppressed(var9_9);
                    }
                    continue;
                }
                zis.close();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unZipForExpectFile(String zipFilePath, String destDirPath, String relativeZipFilePath) {
        boolean isUnZipSuccess = true;
        long total = 0L;
        int lastIndex = relativeZipFilePath.lastIndexOf(SEPARATOR);
        String unZipFileName = relativeZipFilePath.substring(lastIndex + 1);
        String unZipFilePath = destDirPath + File.separator + unZipFileName;
        ZipFileUtils.checkDestDir(destDirPath);
        ZipArchiveEntry entry = null;
        try (ZipFile zipFile = ZipFileUtils.createZipFile(FileUtils.getFile(zipFilePath));){
            if (zipFile == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "zipFile is null");
                boolean bl = false;
                return bl;
            }
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements() && !StringUtils.equals((entry = (ZipArchiveEntry)entries.nextElement()).getName(), relativeZipFilePath.replaceFirst(SEPARATOR, ""))) {
            }
            if (entry == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "entry is null");
                boolean bl = false;
                return bl;
            }
            if (!StringUtils.equals(entry.getName(), relativeZipFilePath.replaceFirst(SEPARATOR, ""))) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "entry not right");
                boolean bl = false;
                return bl;
            }
            try (BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
                 BufferedOutputStream bos = new BufferedOutputStream(FileUtils.openOutputStream(FileUtils.getFile(unZipFilePath)));){
                byte[] bytes = new byte[4096];
                int len = inputStream.read(bytes, 0, 4096);
                while (len != -1) {
                    if ((total += (long)len) > 0x80000000L) {
                        CodeCCUtils.INSTANCE.errorLog(LOGGER, "unzip file is too big.");
                        boolean bl = false;
                        return bl;
                    }
                    bos.write(bytes, 0, len);
                    len = inputStream.read(bytes, 0, 4096);
                }
                bos.flush();
                return isUnZipSuccess;
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Unzip error.");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unZipForExpectDir(String zipFilePath, String destDirPath, String relativePath) {
        ZipFileUtils.checkDestDir(destDirPath);
        try (ZipFile zipFile = ZipFileUtils.createZipFile(FileUtils.getFile(zipFilePath));){
            if (zipFile == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "zipFile is null");
                boolean bl = false;
                return bl;
            }
            long fileSizeCounter = 0L;
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
                String entryName = ZipFileUtils.preProcessEntryName(zipEntry.getName());
                if (!StringUtils.startsWith(entryName, relativePath)) continue;
                String targetUnzipPath = ZipFileUtils.getTargetUnzipPath(destDirPath, relativePath, entryName);
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir(FileUtils.getFile(targetUnzipPath));
                    continue;
                }
                long unZipFileSize = ZipFileUtils.unZipWriteFile(zipFile.getInputStream(zipEntry), targetUnzipPath, fileSizeCounter);
                if (unZipFileSize == -1L) {
                    boolean bl = false;
                    return bl;
                }
                fileSizeCounter += unZipFileSize;
            }
            return true;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Unzip relative directory to destination directory error.", (Throwable)e);
            return false;
        }
    }

    private static String preProcessEntryName(String entryName) {
        String tempEntryName = entryName;
        if (StringUtils.startsWithAny(tempEntryName, SEPARATOR, File.separator)) {
            tempEntryName = StringUtils.substring(tempEntryName, 1, tempEntryName.length());
        }
        if (StringUtils.endsWithAny(tempEntryName, SEPARATOR, File.separator)) {
            tempEntryName = StringUtils.substring(tempEntryName, 0, tempEntryName.length() - 1);
        }
        return tempEntryName;
    }

    private static String getTargetUnzipPath(String destDirPath, String relativePath, String entryName) {
        int lastIndex = StringUtils.lastIndexOf((CharSequence)entryName, relativePath);
        String srcZipRelativePath = StringUtils.substring(entryName, lastIndex + relativePath.length());
        return destDirPath + File.separator + srcZipRelativePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long unZipWriteFile(InputStream inputStream, String targetUnzipPath, long fileSizeCounter) {
        long counter = 0L;
        try (BufferedInputStream buffInputStream = new BufferedInputStream(inputStream);
             BufferedOutputStream buffOutputStream = new BufferedOutputStream(FileUtils.openOutputStream(FileUtils.getFile(targetUnzipPath)));){
            byte[] bytes = new byte[4096];
            int len = buffInputStream.read(bytes, 0, 4096);
            while (len != -1) {
                if ((counter += (long)len) + fileSizeCounter > 0x80000000L) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "File being unzipped is too big.");
                    long l = -1L;
                    return l;
                }
                buffOutputStream.write(bytes, 0, len);
                len = buffInputStream.read(bytes, 0, 4096);
            }
            buffOutputStream.flush();
            return counter;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Unzip relative directory to destination directory error.", (Throwable)e);
        }
        return counter;
    }

    private static void checkDestDir(String destDirPath) {
        File dir = FileUtils.getFile(destDirPath);
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "make destination dir fail");
        }
    }

    private static String sanitzeFileName(String entryName, String intendedDir) throws IOException {
        File file = FileUtils.getFile(intendedDir, entryName);
        String canonicalPath = file.getCanonicalPath();
        File targetFile = FileUtils.getFile(intendedDir);
        String validPath = targetFile.getCanonicalPath();
        if (canonicalPath.startsWith(validPath)) {
            return canonicalPath;
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    private static boolean createDirIfNotExist(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            return true;
        }
        return dir.mkdirs();
    }

    public static int unZipByType(String zipFilePath, String unzipFilePath, boolean isIncludeZipFileName, List<String> unzipFileTypes) {
        if (StringUtils.isAnyEmpty(zipFilePath, unzipFilePath)) {
            return 50100001;
        }
        File zipFile = FileUtils.getFile(zipFilePath);
        String termUnzipFilePath = ZipFileUtils.getFullUnzipPath(unzipFilePath, isIncludeZipFileName, zipFile);
        File unzipFileDir = FileUtils.getFile(termUnzipFilePath);
        FileUtils.deleteQuietly(unzipFileDir);
        if (!ZipFileUtils.createDirIfNotExist(unzipFileDir)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Unzip unzipFileDir mkdirs fail.");
            return 50100002;
        }
        return ZipFileUtils.unzipFile(zipFilePath, unzipFileTypes, termUnzipFilePath, zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int unzipFile(String zipFilePath, List<String> unzipFileTypes, String termUnzipFilePath, File zipFile) {
        int retCode = 50100000;
        boolean isDelZipFile = false;
        long total = 0L;
        int fileNum = 0;
        byte[] buffer = new byte[1024];
        ZipFile zip = null;
        try {
            zip = ZipFileUtils.createZipFile(zipFile);
            if (zip == null) {
                int n = 50100003;
                return n;
            }
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ++fileNum;
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (entry == null) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "entry is null.");
                    continue;
                }
                retCode = ZipFileUtils.checkZipFileEntry(entry, fileNum, unzipFileTypes);
                if (retCode == 50100004) {
                    isDelZipFile = true;
                    break;
                }
                if (retCode == -122312) {
                    retCode = 50100000;
                    continue;
                }
                File entryFile = ZipFileUtils.getZipEntryFile(termUnzipFilePath, entry.getName());
                total = ZipFileUtils.unzipFileEntry(entryFile, zip, entry, buffer, total);
                if (total == -1L) {
                    retCode = 50100005;
                    break;
                }
                if (total <= 0x80000000L) continue;
                retCode = 50100004;
                break;
            }
            if (isDelZipFile) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "Check file size over 2G to delete, filePath is " + zipFilePath);
                FileUtils.deleteQuietly(zipFile);
            }
        }
        finally {
            ZipFile.closeQuietly((ZipFile)zip);
        }
        return retCode;
    }

    private static File getZipEntryFile(String termUnzipFilePath, String entryName) {
        String entryFilePath = termUnzipFilePath + File.separator + entryName;
        File entryFile = FileUtils.getFile(entryFilePath);
        if (entryFile.exists()) {
            FileUtils.deleteQuietly(entryFile);
        }
        return entryFile;
    }

    private static long unzipFileEntry(File outputFile, ZipFile zipFile, ZipArchiveEntry entry, byte[] buffer, long bytesRead) {
        long total = bytesRead;
        try (BufferedOutputStream bos = new BufferedOutputStream(FileUtils.openOutputStream(outputFile));
             BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));){
            int count;
            while ((count = bis.read(buffer, 0, 1024)) != -1 && (total += (long)count) <= 0x80000000L) {
                bos.write(buffer, 0, count);
            }
            if (total <= 0x80000000L) {
                bos.flush();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Error unzip file,IOException.", (Throwable)e);
            total = -1L;
        }
        return total;
    }

    private static int checkZipFileEntry(ZipArchiveEntry entry, int fileNum, List<String> unzipFileTypes) {
        String entryName = entry.getName();
        if ((long)fileNum > 10L || entry.getSize() > 0x80000000L) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Check file size exceeds 2G or Number over 10, file name is " + entryName);
            return 50100004;
        }
        if (entry.isDirectory() || !ZipFileUtils.isCheckFileName(entryName, unzipFileTypes)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Check file name fail, file name is " + entryName);
            return -122312;
        }
        return 50100000;
    }

    private static String getFullUnzipPath(String unzipFilePath, boolean isIncludeZipFileName, File zipFile) {
        String termUnzipFilePath = unzipFilePath;
        if (isIncludeZipFileName) {
            String zipFileName = zipFile.getName();
            if (StringUtils.isNotEmpty(zipFileName)) {
                zipFileName = zipFileName.substring(0, zipFileName.lastIndexOf("."));
            }
            termUnzipFilePath = termUnzipFilePath + File.separator + zipFileName;
        }
        return termUnzipFilePath;
    }
}

