/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.verify.util.HashAlgorithm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class CMSVerifyBuilder
extends BcContentVerifierProviderBuilder {
    private static final List<ASN1ObjectIdentifier> RSA_ALGO = new ArrayList<ASN1ObjectIdentifier>();
    private static final List<ASN1ObjectIdentifier> EC_ALGO = new ArrayList<ASN1ObjectIdentifier>();
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public CMSVerifyBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        ASN1ObjectIdentifier oid = sigAlgId.getAlgorithm();
        if (RSA_ALGO.contains(oid)) {
            return this.getRsaSigner(sigAlgId);
        }
        if (EC_ALGO.contains(oid)) {
            return this.getEcSigner(sigAlgId);
        }
        throw new OperatorCreationException("sigAlgId is not support!");
    }

    private Signer getEcSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        boolean sm2 = GMObjectIdentifiers.sm2sign_with_sm3.equals(sigAlgId.getAlgorithm());
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        if (sm2) {
            if (GMObjectIdentifiers.sm3.equals(digAlg.getAlgorithm())) {
                return new SM2Signer();
            }
            throw new OperatorCreationException("cannot create SM2 signer for hash algorithm " + digAlg.getAlgorithm().getId());
        }
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new DSADigestSigner(new ECDSASigner(), dig);
    }

    private Signer getRsaSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals(sigAlgId.getAlgorithm())) {
            AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
            return new RSADigestSigner(this.digestProvider.get(digAlg));
        }
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals(sigAlgId.getAlgorithm())) {
            throw new OperatorCreationException("signature algorithm " + sigAlgId.getAlgorithm() + " is not allowed");
        }
        RSASSAPSSparams param = RSASSAPSSparams.getInstance(sigAlgId.getParameters());
        ASN1ObjectIdentifier digAlgOid = param.getHashAlgorithm().getAlgorithm();
        AlgorithmIdentifier mfgDigAlgId = AlgorithmIdentifier.getInstance(param.getMaskGenAlgorithm().getParameters());
        Digest dig = HashAlgorithm.of(digAlgOid).createDigest();
        Digest mfgDig = HashAlgorithm.of(mfgDigAlgId.getAlgorithm()).createDigest();
        RSABlindedEngine tmpCipher = new RSABlindedEngine();
        if (param.getTrailerField().intValue() != 1) {
            throw new IllegalArgumentException("unknown trailer field");
        }
        return new PSSSigner((AsymmetricBlockCipher)tmpCipher, dig, mfgDig, param.getSaltLength().intValue(), -68);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }

    static {
        RSA_ALGO.add(PKCSObjectIdentifiers.sha256WithRSAEncryption);
        RSA_ALGO.add(PKCSObjectIdentifiers.sha384WithRSAEncryption);
        RSA_ALGO.add(PKCSObjectIdentifiers.sha512WithRSAEncryption);
        RSA_ALGO.add(PKCSObjectIdentifiers.id_RSASSA_PSS);
        EC_ALGO.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        EC_ALGO.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        EC_ALGO.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        EC_ALGO.add(GMObjectIdentifiers.sm2sign_with_sm3);
    }
}

