/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.verify.util.CMSVerifyUtil;
import com.huawei.support.icscbb.verify.util.CertWrapper;
import com.huawei.support.icscbb.verify.util.CmscbbErr;
import com.huawei.support.icscbb.verify.util.CommonUtil;
import com.huawei.support.icscbb.verify.util.CrlWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public final class CMSVerifyTsUtil {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CMSVerifyTsUtil.class);

    private CMSVerifyTsUtil() {
    }

    public static void verifyTSPMatchCMS(SignerInformationVerifier verifier, CMSTypedData content, TimeStampToken tspToken) throws AnnotatedException, OperatorCreationException, CMSException {
        byte[] resultDigest = null;
        DigestCalculator calc = verifier.getDigestCalculator(tspToken.getTimeStampInfo().getHashAlgorithm());
        OutputStream digOut = calc.getOutputStream();
        if (digOut != null) {
            try {
                content.write(digOut);
                resultDigest = calc.getDigest();
            }
            catch (IOException | CMSException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "write output stream failed.", (Throwable)e);
                throw new CMSException("write output stream failed.");
            }
            finally {
                try {
                    digOut.close();
                }
                catch (IOException e) {
                    CodeCCUtils.INSTANCE.errorLog(LOG, "Close output stream failed.", (Throwable)e);
                }
            }
        }
        if (resultDigest == null || !Arrays.constantTimeAreEqual(resultDigest, tspToken.getTimeStampInfo().getMessageImprintDigest())) {
            throw new AnnotatedException("MessageImprint digest value does not match calculated value.");
        }
    }

    public static void checkTimestampCertChainWithoutEndCrl(CMSSignedData tspData, Date date, X509Certificate tsaEndCert, List<CertWrapper> certList, Map<X500Principal, CrlWrapper> crlMap) throws GeneralSecurityException, AnnotatedException {
        Store<X509CertificateHolder> store = tspData.getCertificates();
        if (!(store instanceof CollectionStore)) {
            throw new AnnotatedException("Type conversion error!");
        }
        CollectionStore tspCerts = (CollectionStore)store;
        X509Certificate baseCheckCert = CommonUtil.getSignCert(tspCerts, tsaEndCert.getIssuerX500Principal(), certList);
        CommonUtil.checkCAUsage(baseCheckCert);
        if (date.before(baseCheckCert.getNotBefore()) || date.after(baseCheckCert.getNotAfter())) {
            throw new CertPathBuilderException(CmscbbErr.PKI_CERT_DATETIME_EXPIRED.toString());
        }
        CMSVerifyUtil.checkCAOfCrl(baseCheckCert, tspCerts, date, certList, crlMap);
    }
}

