/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.verify.util.CRLNode;
import com.huawei.support.icscbb.verify.util.CertWrapper;
import com.huawei.support.icscbb.verify.util.CmsValidationException;
import com.huawei.support.icscbb.verify.util.CommonUtil;
import com.huawei.support.icscbb.verify.util.CrlCompareUtil;
import com.huawei.support.icscbb.verify.util.FileToX509;
import com.huawei.support.icscbb.verify.util.InternalCmscbbConf;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CRLCompare {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(CRLCompare.class);
    public static final int CRL_SAME = 0;
    public static final int CRL_NEW = 1;
    public static final int CRL_OLD = 2;
    public static final int CRL_MIX = 3;
    private final List<String> crtFiles = new ArrayList<String>();
    private final List<byte[]> crtDatas = new ArrayList<byte[]>();

    public CRLCompare(byte[] data) {
        this.crtDatas.add((byte[])data.clone());
    }

    public CRLCompare() {
    }

    public CRLCompare(String crtFile) {
        if (crtFile != null) {
            this.crtFiles.add(crtFile);
        }
    }

    public void addCrtFile(String crtFile) {
        if (crtFile != null) {
            this.crtFiles.add(crtFile);
        }
    }

    public void addCrtData(byte[] crtData) {
        if (crtData != null && crtData.length != 0) {
            this.crtDatas.add(crtData);
        }
    }

    private List<X509CertificateHolder> loadRoot() throws GeneralSecurityException, AnnotatedException, IOException {
        X509CertificateHolder cert;
        if (this.crtFiles.isEmpty() && this.crtDatas.isEmpty()) {
            throw new AnnotatedException("Certificate setting has conflict.");
        }
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>();
        for (String crtFile : this.crtFiles) {
            cert = FileToX509.readCertHolder(crtFile);
            if (!this.isRootCert(cert)) continue;
            certs.add(cert);
        }
        for (byte[] crtData : this.crtDatas) {
            cert = new X509CertificateHolder(FileToX509.readCertBuf(crtData).getEncoded());
            if (!this.isRootCert(cert)) continue;
            certs.add(cert);
        }
        return certs;
    }

    private boolean isRootCert(X509CertificateHolder trustAnchor) throws AnnotatedException {
        CertWrapper trust = null;
        try {
            trust = new CertWrapper(trustAnchor);
        }
        catch (CmsValidationException e) {
            throw new AnnotatedException(e.getErrorCode().toString());
        }
        return trust.isSelfSigned();
    }

    private CRLNode createAndVerifyNode(String crlFile, List<X509CertificateHolder> root, boolean isContainCa) throws GeneralSecurityException, AnnotatedException, CmsValidationException {
        InternalCmscbbConf conf = new InternalCmscbbConf(crlFile);
        for (X509CertificateHolder rootCertHolder : root) {
            conf.addTrustAnchor(rootCertHolder);
        }
        CRLNode crlNode = new CRLNode(isContainCa, conf);
        crlNode.checkCRLs();
        return crlNode;
    }

    public int compare(String updateCRLFile, String originalCRLFile) throws AnnotatedException, GeneralSecurityException {
        int oriCrlSize;
        int updateCrlSize;
        CRLNode updateCRL = null;
        CRLNode originalCRL = null;
        try {
            List<X509CertificateHolder> root = this.loadRoot();
            updateCRL = this.createAndVerifyNode(updateCRLFile, root, true);
            originalCRL = this.createAndVerifyNode(originalCRLFile, root, true);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to parse the certificate.", (Throwable)e);
            throw new AnnotatedException("Failed to parse the certificate.");
        }
        catch (CmsValidationException e) {
            throw new AnnotatedException(e.getMessage());
        }
        if (updateCRL.isHasDuplicateCrlIssuer() || originalCRL.isHasDuplicateCrlIssuer()) {
            return 3;
        }
        int status = updateCRL.compareUpdateTime(originalCRL);
        if (status == 0 && (updateCrlSize = updateCRL.getConf().getCrlMap().size()) != (oriCrlSize = originalCRL.getConf().getCrlMap().size())) {
            int n = status = updateCrlSize > oriCrlSize ? 1 : 2;
        }
        if (status == 1) {
            if (!originalCRL.checkCRLIssuer(updateCRL)) {
                status = 3;
            }
        } else if (!updateCRL.checkCRLIssuer(originalCRL)) {
            status = 3;
        }
        return status;
    }

    private List<byte[]> updateLocalList(List<X509Certificate> certs, List<X509CRL> crls, List<X509CertificateHolder> root, String localCRLFile, boolean isSaveCa) throws GeneralSecurityException, AnnotatedException, IOException, CmsValidationException {
        CRLNode localCrl = this.createAndVerifyNode(localCRLFile, root, isSaveCa);
        if (localCrl.isHasDuplicateCrlIssuer()) {
            throw new AnnotatedException("there are duplicate crls in the localCrl.");
        }
        for (X509CRL crl : crls) {
            localCrl.updateCrl(crl);
        }
        return localCrl.getUpdateCrlList(certs);
    }

    private List<byte[]> covertBundleToList(List<X509Certificate> certs, List<X509CRL> crls, boolean isContainCa) throws CRLException, CertificateEncodingException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (X509CRL crl : crls) {
            result.add(crl.getEncoded());
        }
        if (isContainCa) {
            for (X509Certificate cert : certs) {
                if (!CrlCompareUtil.isCaCert(cert)) continue;
                result.add(cert.getEncoded());
            }
        }
        return result;
    }

    private void updateLocalCrl(List<X509Certificate> certs, List<X509CRL> crls, List<X509CertificateHolder> roots, String localCRLFile, boolean isSaveCa) throws GeneralSecurityException, AnnotatedException, IOException, CmsValidationException {
        List<byte[]> updateCrlList = CommonUtil.fileIsEmpty(localCRLFile) ? this.covertBundleToList(certs, crls, isSaveCa) : this.updateLocalList(certs, crls, roots, localCRLFile, isSaveCa);
        CommonUtil.updateFile(localCRLFile, updateCrlList);
    }

    public void updateLocalCrlFile(String updateCRLFile, String localCRLFile, boolean isSaveCa) throws AnnotatedException, GeneralSecurityException {
        if (updateCRLFile == null || localCRLFile == null || !new File(localCRLFile).exists()) {
            throw new AnnotatedException("file is not exsit!");
        }
        try {
            List<X509CertificateHolder> root = this.loadRoot();
            CRLNode updateCRL = this.createAndVerifyNode(updateCRLFile, root, true);
            if (updateCRL.isHasDuplicateCrlIssuer()) {
                throw new AnnotatedException("there are duplicate crls in the updateCrl.");
            }
            this.updateLocalCrl(updateCRL.getConf().getX509Certs(), updateCRL.getConf().getX509CRLs(), root, localCRLFile, isSaveCa);
        }
        catch (CmsValidationException | IOException e) {
            throw new AnnotatedException(e.getMessage());
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

