/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.verify.util;

import com.huawei.support.icscbb.verify.util.CertWrapper;
import com.huawei.support.icscbb.verify.util.CmsValidationException;
import com.huawei.support.icscbb.verify.util.CmscbbErr;
import com.huawei.support.icscbb.verify.util.CommonUtil;
import com.huawei.support.icscbb.verify.util.CrlCompareUtil;
import com.huawei.support.icscbb.verify.util.CrlWrapper;
import com.huawei.support.icscbb.verify.util.InternalCmscbbConf;
import com.huawei.support.icscbb.verify.util.PkiValidator;
import com.huawei.support.icscbb.verify.util.ValidationResult;
import java.security.GeneralSecurityException;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.AnnotatedException;

class CRLNode {
    private static final String MESSAGE = "CRL has not been checked!";
    private final List<X509CRL> rootCRLs = new ArrayList<X509CRL>();
    private final boolean isContainCa;
    private final InternalCmscbbConf conf;
    private Map<X500Principal, X509CRL> crlMap;
    private Map<X500Principal, X509Certificate> certMap;

    public CRLNode() {
        this(true);
    }

    public CRLNode(boolean isContainCa) {
        this(isContainCa, null);
        this.crlMap = null;
        this.certMap = null;
    }

    public CRLNode(boolean isContainCa, InternalCmscbbConf conf) {
        this.isContainCa = isContainCa;
        this.conf = conf;
    }

    public List<X509CRL> getRootCRLs() {
        return this.rootCRLs;
    }

    public InternalCmscbbConf getConf() {
        return this.conf;
    }

    private void checkCrlMap(boolean isUnchecked, String expMsg) throws AnnotatedException {
        if (isUnchecked) {
            throw new AnnotatedException(expMsg);
        }
    }

    Optional<Date> getDate(X500Principal x500) throws AnnotatedException {
        this.checkCrlMap(this.isUnChecked(), MESSAGE);
        X509CRL crl = this.crlMap.get(x500);
        return crl == null ? Optional.empty() : Optional.of(crl.getThisUpdate());
    }

    boolean lackCRLIssuer(X500Principal issuer) throws AnnotatedException {
        this.checkCrlMap(this.isUnChecked(), MESSAGE);
        return !this.crlMap.containsKey(issuer);
    }

    private void crlVerify(X509CRL crl) throws GeneralSecurityException, AnnotatedException {
        boolean found = false;
        for (Map.Entry<X500Principal, X509Certificate> entry : this.certMap.entrySet()) {
            if (!entry.getKey().equals(crl.getIssuerX500Principal())) continue;
            crl.verify(entry.getValue().getPublicKey());
            found = true;
            break;
        }
        if (!found) {
            throw new AnnotatedException("CRL iusser not found!");
        }
    }

    void checkCRLs() throws GeneralSecurityException, AnnotatedException, CmsValidationException {
        this.certMap = new HashMap<X500Principal, X509Certificate>();
        this.crlMap = new HashMap<X500Principal, X509CRL>();
        for (X509Certificate cert : this.conf.getX509Certs()) {
            this.certMap.put(cert.getSubjectX500Principal(), cert);
        }
        for (X509CRL crl : this.conf.getX509CRLs()) {
            if (this.isContainCa) {
                ValidationResult result = this.issuerCertVerify(this.certMap.get(crl.getIssuerX500Principal()), crl);
                if (result.getErrorCode() != CmscbbErr.OK) {
                    throw new CertPathBuilderException("Failed to build the certificate chain.");
                }
                this.crlVerify(crl);
            }
            this.crlMap.put(crl.getIssuerX500Principal(), crl);
        }
    }

    ValidationResult issuerCertVerify(X509Certificate endCert, X509CRL crl) throws AnnotatedException, GeneralSecurityException, CmsValidationException {
        if (endCert == null) {
            throw new AnnotatedException("CRL publisher not found!");
        }
        this.addRootCrl(crl);
        Date thisUpDate = crl.getThisUpdate();
        Date nextUpDate = crl.getNextUpdate();
        ValidationResult res = new ValidationResult().setErrorCode(CmscbbErr.OK);
        List<CrlWrapper> crlWrappers = this.conf.getCrlWrappers();
        PkiValidator pkiVerifier = new PkiValidator(this.conf);
        pkiVerifier.setVerificationTime(crl.getThisUpdate());
        pkiVerifier.checkTrustOfSignerCert(res, false, new CertWrapper(endCert.getEncoded()), crlWrappers);
        return res;
    }

    void addRootCrl(X509CRL crl) throws GeneralSecurityException {
        for (CertWrapper certWrapper : this.conf.getTrustAnchors()) {
            X509Certificate cert = CommonUtil.coverte(certWrapper.getCert());
            if (!crl.getIssuerX500Principal().equals(cert.getSubjectX500Principal())) continue;
            this.rootCRLs.add(crl);
            return;
        }
    }

    boolean isUnChecked() {
        return this.crlMap == null;
    }

    boolean isHasDuplicateCrlIssuer() throws AnnotatedException {
        boolean isVaild = this.isContainCa && this.isUnChecked();
        this.checkCrlMap(isVaild, MESSAGE);
        return this.conf.isHasDuplicateCrlIssuer();
    }

    int compareUpdateTime(CRLNode compareCRL) throws AnnotatedException {
        boolean isAllUnChecked = this.isUnChecked() || compareCRL.isUnChecked();
        this.checkCrlMap(isAllUnChecked, "Comparing CRLs have not been checked.");
        int status = 0;
        for (X509CRL crl : this.crlMap.values()) {
            Date data1 = crl.getThisUpdate();
            Date data2 = compareCRL.getDate(crl.getIssuerX500Principal()).orElse(null);
            status = CrlCompareUtil.getCompareRes(data2, data1, status);
            if (status != 3) continue;
            break;
        }
        return status;
    }

    boolean checkCRLIssuer(CRLNode compareCRL) throws AnnotatedException {
        boolean isAllUnChecked = this.isUnChecked() || compareCRL.isUnChecked();
        this.checkCrlMap(isAllUnChecked, MESSAGE);
        for (X500Principal issuer : this.crlMap.keySet()) {
            boolean isRevoked = compareCRL.lackCRLIssuer(issuer) && CrlCompareUtil.unrevokeIssuerByRootCRL(compareCRL.getRootCRLs(), this.certMap.get(issuer).getSerialNumber());
            if (!isRevoked) continue;
            return false;
        }
        return true;
    }

    void updateCrl(X509CRL crl) throws GeneralSecurityException, AnnotatedException {
        this.checkCrlMap(this.isUnChecked(), MESSAGE);
        this.addRootCrl(crl);
        X500Principal crlIssuerX500Principal = crl.getIssuerX500Principal();
        if (!this.crlMap.containsKey(crlIssuerX500Principal)) {
            this.crlMap.put(crlIssuerX500Principal, crl);
            return;
        }
        X509CRL localCrl = this.crlMap.get(crlIssuerX500Principal);
        if (CommonUtil.crlCompare(crl, localCrl) >= 0) {
            this.crlMap.remove(crlIssuerX500Principal);
            this.crlMap.put(crlIssuerX500Principal, crl);
        }
    }

    List<byte[]> getUpdateCrlList(List<X509Certificate> certList) throws CRLException, CertificateEncodingException, AnnotatedException {
        this.checkCrlMap(this.isUnChecked(), MESSAGE);
        ArrayList<byte[]> updateCrlList = new ArrayList<byte[]>();
        for (X509CRL crl : this.crlMap.values()) {
            if (!CrlCompareUtil.isUnrevoked(this.isContainCa, certList, this.certMap, this.rootCRLs, crl)) continue;
            updateCrlList.add(crl.getEncoded());
        }
        if (this.isContainCa) {
            for (X509Certificate cert : this.certMap.values()) {
                CrlCompareUtil.updateCert(updateCrlList, this.rootCRLs, cert);
            }
            for (X509Certificate cert : certList) {
                if (this.certMap.containsKey(cert.getSubjectX500Principal())) continue;
                CrlCompareUtil.updateCert(updateCrlList, this.rootCRLs, cert);
            }
        }
        return updateCrlList;
    }
}

