/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.common.resources.messages;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.wsf.core.HWEncoder;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import org.owasp.esapi.errors.EncodingException;

public class MessageWithLink
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(MessageWithLink.class);

    public MessageWithLink(String htmlBody) {
        super("text/html", "<html><body style=\"" + MessageWithLink.getStyle() + "\">" + htmlBody + "</body></html>");
        this.addHyperlinkListener(MessageWithLink::handlerHyperlinkEvent);
        this.setEditable(false);
        this.setBorder(null);
    }

    private static void handlerHyperlinkEvent(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType type = hyperlinkEvent.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = hyperlinkEvent.getURL();
            if (url == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "MessageWithLink Url is null.");
                return;
            }
            String subject = I18nResources.INSTANCE.getValueByKey("common.mailto.subject");
            String body = I18nResources.INSTANCE.getValueByKey("common.mailto.body");
            try {
                String uri = url + "?subject=" + HWEncoder.encodeForURL(subject) + "&body=" + HWEncoder.encodeForURL(body);
                Desktop.getDesktop().mail(new URI(uri.replace("+", "%20")));
            }
            catch (EncodingException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "MessageWithLink Encoding error.", (Throwable)e);
            }
            catch (IOException | URISyntaxException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "MessageWithLink Open mail error.", (Throwable)e);
            }
        }
    }

    private static StringBuffer getStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        StringBuffer style = new StringBuffer();
        style.append("font-family:").append(font.getFamily()).append(";").append("font-weight:").append(font.isBold() ? "bold" : "normal").append(";").append("font-size:").append(font.getSize()).append("pt;").append("background-color: rgb(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(");");
        return style;
    }
}

