/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.config.init;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icslite.config.dao.ConfigDao;
import com.huawei.support.icslite.config.util.ConfigUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ConfigInitHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ConfigInitHandler.class);

    public static ConfigInitHandler getInstance() {
        return ConfigInitHandlerHolder.INSTANCE;
    }

    public void init() {
        Properties configProps;
        File configFile = FileUtils.getFile(ConfigUtil.getConfigFilePath());
        if (!configFile.exists()) {
            this.createConfigFile(configFile);
        }
        if ((configProps = PropertiesUtils.getPropertiesByFile(configFile)) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IcsliteConfig Properties load failed.");
            return;
        }
        this.addDefaultConfig(configProps);
        this.addSceneConfig(configProps);
        ConfigDao.getInstance().setConfig(configProps);
        ConfigUtil.storeIcsLiteConfig();
    }

    private void addSceneConfig(Properties configProps) {
        this.addConfig(configProps, ConfigUtil.getScenePropertiesFilePath());
    }

    private void addDefaultConfig(Properties configProps) {
        this.addConfig(configProps, ConfigUtil.getDefaultConfigFilePath());
    }

    private void addConfig(Properties configProps, String newConfigFilePath) {
        File newConfigFile = FileUtils.getFile(newConfigFilePath);
        try {
            Properties newConfigProps = PropertiesUtils.getPropertiesByFile(newConfigFile);
            if (newConfigProps == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Load config file properties failed.");
                return;
            }
            newConfigProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(newKey, newValue) -> this.setProperty(configProps, newKey, newValue)));
        }
        catch (IllegalArgumentException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Add conifg error.", (Throwable)e);
        }
    }

    private void setProperty(Properties configProps, Object newKey, Object newValue) {
        if (ObjectUtils.isEmpty(newKey) || ObjectUtils.isEmpty(newValue)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Add config error, new key or new value object empty.");
            return;
        }
        if (configProps.containsKey(newKey)) {
            return;
        }
        String strNewKey = newKey.toString();
        String strNewValue = newValue.toString();
        if (!ConfigUtil.isKeyLegal(strNewKey) || !ConfigUtil.isValueLegal(strNewValue)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Set config error, key or value illegal.key = {0} ,value = {1}", strNewKey, strNewValue);
            return;
        }
        configProps.setProperty(strNewKey, strNewValue);
    }

    private boolean createConfigFile(File configFile) {
        try {
            if (!configFile.createNewFile()) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create icsLiteConfig.properties failed.");
                return false;
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The icsLiteConfig.properties file does not exist and create failed.IOException.");
            return false;
        }
        return true;
    }

    private static class ConfigInitHandlerHolder {
        private static final ConfigInitHandler INSTANCE = new ConfigInitHandler();

        private ConfigInitHandlerHolder() {
        }
    }
}

