/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.config.migration;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.config.migration.MigrationCrlConfigHandler;
import com.huawei.support.icslite.config.migration.MigrationDownloadConfigHandler;
import com.huawei.support.icslite.config.migration.MigrationHandlerTemplate;
import com.huawei.support.icslite.config.migration.MigrationIcsLiteSettingConfigHandler;
import com.huawei.support.icslite.config.migration.MigrationLiteSceneConfigHandler;
import com.huawei.support.icslite.config.migration.MigrationNetWorkConfigHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.ArrayList;
import java.util.List;

public class ConfigMigrationBroker {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ConfigMigrationBroker.class);
    private List<MigrationHandlerTemplate> migrationHandlers = new ArrayList<MigrationHandlerTemplate>();

    public static ConfigMigrationBroker getInstance() {
        return ConfigMigrationBrokerHolder.INSTANCE;
    }

    private ConfigMigrationBroker addMigrationHandler(MigrationHandlerTemplate migrationHandler) {
        this.migrationHandlers.add(migrationHandler);
        return this;
    }

    public void execute() {
        String migrated = ConfigServiceHandler.getInstance().getFromFile("system.old.config.migrated");
        if ("true".equals(migrated)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Migration old config.Old config has migrated.");
            return;
        }
        this.migrationHandlers.forEach(MigrationHandlerTemplate::doMigration);
        ConfigServiceHandler.getInstance().set("system.old.config.migrated", "true");
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Migration old config end.");
    }

    public ConfigMigrationBroker init() {
        this.addMigrationHandler(new MigrationCrlConfigHandler()).addMigrationHandler(new MigrationDownloadConfigHandler()).addMigrationHandler(new MigrationIcsLiteSettingConfigHandler()).addMigrationHandler(new MigrationNetWorkConfigHandler()).addMigrationHandler(new MigrationLiteSceneConfigHandler());
        return this;
    }

    private static class ConfigMigrationBrokerHolder {
        private static final ConfigMigrationBroker INSTANCE = new ConfigMigrationBroker();

        private ConfigMigrationBrokerHolder() {
        }
    }
}

