/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.config.migration;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icslite.config.dao.ConfigDao;
import com.huawei.support.icslite.config.util.ConfigUtil;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class MigrationHandlerTemplate {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(MigrationHandlerTemplate.class);
    String oldConfigFilePath = "";
    Properties oldConfigProps;
    Properties convertedConfigProps = new Properties();

    protected void loadOldConfig() {
        File configFile = FileUtils.getFile(this.oldConfigFilePath);
        if (!configFile.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Migration old config error. old configFile not exist.");
            return;
        }
        this.oldConfigProps = PropertiesUtils.getPropertiesByFile(configFile);
    }

    protected abstract void convertOldConfigKeys();

    protected void saveConvertedConfig() {
        if (this.convertedConfigProps.isEmpty()) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Migration old config , convertedConfigProps empty.");
            return;
        }
        ConfigDao.getInstance().addConfig(this.convertedConfigProps);
        ConfigUtil.storeIcsLiteConfig();
    }

    protected final void doMigration() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Do config migration , oldConfigFile is {0} .", this.oldConfigFilePath.replaceAll("^.*\\\\", ""));
        this.loadOldConfig();
        this.convertOldConfigKeys();
        this.saveConvertedConfig();
    }

    protected void convertSingleKey(String oldKey, String newKey) {
        String value = this.oldConfigProps.getProperty(oldKey);
        if (!ConfigUtil.isValueLegal(value)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Config migration , convertSingleKey error,old value illegal ,value = {0}", value);
            return;
        }
        if (StringUtils.isNotBlank(value)) {
            this.convertedConfigProps.remove(oldKey);
            this.convertedConfigProps.setProperty(newKey, value);
        }
    }
}

