/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.config.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icslite.config.dao.ConfigDao;
import com.huawei.support.icslite.config.service.ConfigService;
import com.huawei.support.icslite.config.util.ConfigUtil;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ConfigServiceHandler
implements ConfigService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ConfigServiceHandler.class);

    public static ConfigServiceHandler getInstance() {
        return ConfigServiceHandlerHolder.INSTANCE;
    }

    @Override
    public String get(String key) {
        Properties props = ConfigDao.getInstance().getConfig();
        Object value = props.get(key);
        if (!this.isValueAvaiable(key, value)) {
            return "";
        }
        return value.toString();
    }

    private boolean isValueAvaiable(String key, Object value) {
        if (ObjectUtils.isEmpty(value)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Get config value empty, key = {0}", key);
            return false;
        }
        if (!ConfigUtil.isValueLegal(value.toString())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get config value error, key = {0}", key);
            return false;
        }
        return true;
    }

    @Override
    public String getFromFile(String key) {
        File configFile = FileUtils.getFile(ConfigUtil.getConfigFilePath());
        if (!configFile.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get config value from file error, config file not exist.");
            return "";
        }
        Properties configProps = PropertiesUtils.getPropertiesByFile(configFile);
        if (configProps == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IcsliteConfig Properties load failed.");
            return "";
        }
        Object value = configProps.get(key);
        if (!this.isValueAvaiable(key, value)) {
            return "";
        }
        return value.toString();
    }

    @Override
    public String getOrSetDefault(String key, String defaultValue) {
        Properties props = ConfigDao.getInstance().getConfig();
        Object value = props.get(key);
        if (ObjectUtils.isNotEmpty(value) && ConfigUtil.isValueLegal(value.toString())) {
            return value.toString();
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Get config value empty, set and return new value.key = {0} ,value = {1}", key, defaultValue);
        this.set(key, defaultValue);
        return defaultValue;
    }

    @Override
    public boolean set(String key, String value) {
        if (!ConfigUtil.isKeyLegal(key) || !ConfigUtil.isValueLegal(value)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Set config error, key or value illegal.key = {0} ,value = {1}", key, value);
            return false;
        }
        Properties props = ConfigDao.getInstance().getConfig();
        if (props == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "GetConfig Properties failed.");
            return false;
        }
        props.setProperty(key, value);
        return ConfigUtil.storeIcsLiteConfig();
    }

    @Override
    public boolean remove(String key) {
        if (!ConfigUtil.isKeyLegal(key)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Remove config error, key illegal,key = {0} .", key);
            return false;
        }
        Properties props = ConfigDao.getInstance().getConfig();
        props.remove(key);
        return ConfigUtil.storeIcsLiteConfig();
    }

    private static class ConfigServiceHandlerHolder {
        private static final ConfigServiceHandler INSTANCE = new ConfigServiceHandler();

        private ConfigServiceHandlerHolder() {
        }
    }
}

