/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.init.ConfigInitHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.upgrader.messages.UpgradeProgressBar;
import com.huawei.support.icslite.upgrader.service.UpgradeProcess;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeOperate {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UpgradeOperate.class);

    private UpgradeOperate() {
    }

    public static void main(String[] args) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Upgrader initialization.");
        ConfigInitHandler.getInstance().init();
        ConfigServiceHandler.getInstance().set("system.his.version", IcsCommonServiceHandler.getInstance().getAppVersion());
        UpgradeOperate.copyConfigFile();
        String liteLanguage = UpgradeOperate.getLanguage();
        I18nResources.INSTANCE.initResourceBundle(liteLanguage);
        ThreadPoolExecutor commonThreadPool = ThreadPoolFactory.getThreadPool("common", 2, 300, 10, 100);
        UpgradeProcess upgradeProcess = new UpgradeProcess();
        commonThreadPool.execute(upgradeProcess);
        UpgradeProgressBar.createProgressGui();
    }

    private static void copyConfigFile() {
        String appRootDir = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator;
        File destFile = FileUtils.getFile(appRootDir + "userdata" + File.separator + "icsLiteSetting.properties");
        if (destFile.exists()) {
            return;
        }
        File srcFile = FileUtils.getFile(appRootDir + "conf" + File.separator + "icsLite.properties");
        if (srcFile.exists()) {
            try {
                FileUtils.copyFile(srcFile, destFile);
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Copy icsLite.properties file error.", (Throwable)e);
            }
        }
    }

    private static String getLanguage() {
        String liteLanguage = ConfigServiceHandler.getInstance().get("system.lang");
        if (StringUtils.isNotBlank(liteLanguage)) {
            return liteLanguage;
        }
        Optional<Properties> propertiesOptional = PropertiesUtils.getPropertiesByFileName(IcsCommonServiceHandler.getInstance().getComponentFilePath("conf", "icsLite.properties"));
        if (!propertiesOptional.isPresent() || propertiesOptional.get().isEmpty()) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IcsliteProperties load failed, use default language.");
            return "en";
        }
        String langProps = propertiesOptional.get().getProperty("lang");
        if (StringUtils.isBlank(langProps)) {
            return "en";
        }
        liteLanguage = langProps.trim();
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Current language is:{0}", liteLanguage);
        return liteLanguage;
    }
}

