/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.messages;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.common.resources.utils.CmdCharacterUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.upgrader.constant.UpgraderConstants;
import com.huawei.support.icslite.upgrader.util.FileOperateUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class BubbleSettings {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(BubbleSettings.class);
    private static final String UPGRADE_FAIL_LINK_URL = String.format(Locale.ENGLISH, I18nResources.INSTANCE.getValueByKey("upgrade.gui.fail.link.url"), StringUtils.defaultIfBlank(ConfigServiceHandler.getInstance().get("server.domain.suffix"), ".huawei.com"));

    private BubbleSettings() {
    }

    public static void bubbleWindowEvent(String failStatus, String appUpgradeState, String appRollbackState) {
        FileOperateUtil.setWindowsUiStyle();
        JButton button = new JButton(I18nResources.INSTANCE.getValueByKey("upgrade.gui.confirm.button"));
        JFrame frame = new JFrame();
        frame.setAlwaysOnTop(true);
        frame.setVisible(false);
        Object[] buttons = new JButton[]{button};
        BubbleSettings.windowsClosedEvent(button, frame, appRollbackState);
        JPanel jpanel = BubbleSettings.initJpanel(failStatus, appUpgradeState, appRollbackState);
        JOptionPane.showOptionDialog(frame, jpanel, I18nResources.INSTANCE.getValueByKey("upgrade.progressbar.gui.title"), 0, 0, null, buttons, buttons[0]);
        if ("10".equals(appRollbackState)) {
            String startPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgraderConstants.START_SERVER_PATH;
            File file = FileUtils.getFile(startPath);
            if (file.exists()) {
                SystemCommandUtils.cmdExec("cmd /c " + CmdCharacterUtils.pathHandler(startPath));
            } else {
                IcsCommonServiceHandler.getInstance().startApp();
            }
        }
    }

    private static JPanel initJpanel(String failStatus, String appUpgradeState, String appRollbackState) {
        JPanel upgradeFailLabelPanel = new JPanel();
        JLabel contentJlabel = new JLabel(BubbleSettings.setModeWithContent(failStatus, appRollbackState));
        upgradeFailLabelPanel.setLayout(new BorderLayout());
        upgradeFailLabelPanel.add((Component)contentJlabel, "West");
        if (StringUtils.equals(appUpgradeState, "41")) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Enter upgrade permission failed init jpanel.");
            String upgradeFailLink = String.format(Locale.ENGLISH, I18nResources.INSTANCE.getValueByKey("upgrade.gui.fail.link"), StringUtils.defaultIfBlank(ConfigServiceHandler.getInstance().get("server.domain.suffix"), ".huawei.com"));
            if (StringUtils.isNotBlank(upgradeFailLink)) {
                JLabel upgradeFailLinkJlabel = new JLabel(upgradeFailLink);
                upgradeFailLinkJlabel.setCursor(new Cursor(12));
                BubbleSettings.goUpgradeLink(upgradeFailLinkJlabel);
                upgradeFailLabelPanel.add((Component)upgradeFailLinkJlabel, "Center");
                JLabel endJlabel = new JLabel(I18nResources.INSTANCE.getValueByKey("upgrade.gui.upgrade.permission.failed.end"));
                upgradeFailLabelPanel.add((Component)endJlabel, "East");
            }
        }
        return upgradeFailLabelPanel;
    }

    private static void goUpgradeLink(JLabel jlabel) {
        jlabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(UPGRADE_FAIL_LINK_URL));
                }
                catch (IOException exception) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "Upgrade fail case page open failed.", (Throwable)exception);
                }
                catch (URISyntaxException exception) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "Upgrade fail case page open URISyntaxException.", (Throwable)exception);
                }
            }
        });
    }

    private static void windowsClosedEvent(JButton button, JFrame frame, String appRollbackState) {
        button.addActionListener(paramActionEvent -> BubbleSettings.closeWindow(button, frame, appRollbackState));
    }

    private static void closeWindow(JButton button, JFrame frame, String appRollbackState) {
        Window win;
        if ("10".equals(appRollbackState)) {
            OperationLogUtils.INSTANCE.successOperationLog("liteupgrade", "ROLLBACK", "rollback succeed,user operated confirm button.");
        }
        if ("30".equals(appRollbackState)) {
            OperationLogUtils.INSTANCE.successOperationLog("liteupgrade", "ROLLBACK", "rollback failed,user operated confirm button.");
        }
        if ((win = SwingUtilities.getWindowAncestor(button)) != null) {
            win.dispose();
        }
        if (frame != null) {
            frame.dispose();
        }
    }

    private static String setModeWithContent(String failStatusCode, String appRollbackState) {
        if (StringUtils.equals(failStatusCode, "41")) {
            return I18nResources.INSTANCE.getValueByKey("upgrade.gui.upgrade.permission.failed");
        }
        if (StringUtils.equals(appRollbackState, "10")) {
            return I18nResources.INSTANCE.getValueByKey("upgrade.gui.upgrade.failed");
        }
        return I18nResources.INSTANCE.getValueByKey("upgrade.gui.rollback.failed");
    }
}

