/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.messages;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.upgrader.util.FileOperateUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class UpgradeProgressBar {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UpgradeProgressBar.class);
    private static final int INT_UNIT = 2;
    private static final int FRAME_WIDTH = 350;
    private static final int FRAME_HEIGHT = 160;
    private static final int INTERNAL_SPACING_TOP = 10;
    private static final int INTERNAL_SPACING = 5;
    private static final int LABEL_HEIGHT = 10;
    private static final int PROGRESS_WIDTH = 310;
    private static final int PROGRESS_HEIGHT = 20;
    private static final int UPDATE_SLEEP_MILLIS = 1000;
    private static final int BACKUP_THRESHOLD = 55;
    private static final int SIGNATURE_THRESHOLD = 75;
    private static final int UPGRADE_THRESHOLD = 95;
    private static final int MAX_THRESHOLD = 100;
    private static final int SLEEP_MILLIS = 1000;
    private static final int COLOR_G_VALUE = 153;
    private static final int COLOR_B_VALUE = 204;
    private static final int FONT_WEIGHT = 13;
    private static final int TEXT_MAX_WIDTH = 240;
    private static final int CONTENT_HEIGHT = 20;
    private static final String PICTURE_NAME = "upgrade-hover.png";
    private static final URL PIC_PATH;
    private static int progress;

    public static void createProgressGui() {
        FileOperateUtil.setWindowsUiStyle();
        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(PIC_PATH));
        JFrame frame = new JFrame();
        frame.setUndecorated(true);
        frame.setAlwaysOnTop(true);
        frame.setSize(350, 160);
        frame.setIconImage(imageIcon.getImage());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        frame.setLocation((ge.getMaximumWindowBounds().width - frame.getWidth()) / 2, (ge.getMaximumWindowBounds().height - frame.getHeight()) / 2);
        frame.setLocationRelativeTo(null);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(10, 5, 5, 5));
        frame.add(contentPane);
        contentPane.setLayout(new FlowLayout(1, 5, 5));
        JLabel labalContent = new JLabel();
        String context = String.format(Locale.ROOT, "<html><div style=\"width:%dpx;\">%s</div><html>", 240, I18nResources.INSTANCE.getValueByKey("upgrade.progressbar.gui.content"));
        labalContent.setText(context);
        labalContent.setFont(new Font("Aial", 0, 13));
        labalContent.setSize(350, 20);
        contentPane.add(labalContent);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        progressBar.setPreferredSize(new Dimension(310, 20));
        progressBar.setForeground(new Color(0, 153, 204));
        progressBar.setFont(new Font("Aial", 0, 13));
        contentPane.add((Component)progressBar, "West");
        JLabel label = new JLabel(I18nResources.INSTANCE.getValueByKey("upgrade.progressbar.gui.title"));
        label.setFont(new Font("Aial", 0, 13));
        label.setSize(350, 10);
        label.setIcon(imageIcon);
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        labelPanel.setLayout(new FlowLayout(3, 5, 5));
        labelPanel.add(label);
        frame.add((Component)labelPanel, "North");
        frame.setVisible(true);
        UpgradeProgressBar.setProgressBarValue(progressBar, frame);
    }

    public static void setProcess(int currentProgress) {
        progress = currentProgress;
    }

    private static void setProgressBarValue(JProgressBar progressBar, JFrame frame) {
        block10: {
            int pv = 0;
            do {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "when app loads progressbar,thread sleep error.", (Throwable)e);
                }
                progressBar.setValue(pv);
                ++pv;
                if (progress == 55) {
                    if (pv <= 55) {
                        pv = 55;
                    }
                    if (pv >= 75) {
                        --pv;
                    }
                }
                if (progress == 75) {
                    if (pv <= 75) {
                        pv = 75;
                    }
                    if (pv >= 95) {
                        --pv;
                    }
                }
                if (progress == 95 && pv <= 95) {
                    UpgradeProgressBar.upgradeSuccess(progressBar, frame);
                    break block10;
                }
                if (pv < 95) continue;
                --pv;
            } while (progress <= 100);
            UpgradeProgressBar.deleteFile();
            frame.dispose();
        }
    }

    private static void upgradeSuccess(JProgressBar progressBar, JFrame frame) {
        try {
            progressBar.setValue(100);
            TimeUnit.MILLISECONDS.sleep(1000L);
            UpgradeProgressBar.deleteFile();
            frame.dispose();
            IcsCommonServiceHandler.getInstance().startApp();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "when app upgrade finish,thread sleep error.", (Throwable)e);
        }
    }

    private static void deleteFile() {
        boolean isDel = FileOperateUtil.deleteUpgradeFile();
        if (!isDel) {
            System.exit(0);
        }
    }

    static {
        ClassLoader classLoader = UpgradeProgressBar.class.getClassLoader();
        PIC_PATH = classLoader.getResource(PICTURE_NAME);
    }
}

