/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.service;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.upgrader.dto.FileInfoDto;
import com.huawei.support.icslite.upgrader.service.UpgradeStateHandler;
import com.huawei.support.icslite.upgrader.service.UpgraderService;
import com.huawei.support.icslite.upgrader.util.FileOperateUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;

public class RollbackOperateService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(RollbackOperateService.class);

    public static void rollBackProcess(String backupResource, String appPath, String softVersion, String zipFileName) {
        try {
            List<FileInfoDto> fileInfos;
            UpgradeStateHandler.getInstance().setAppRollbackState("10");
            File resourceFile = FileUtils.getFile(backupResource);
            if (!resourceFile.exists()) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "Rollback app,the resource file:{0} doesn't exist.", resourceFile.getName());
            }
            if (CollectionUtils.isEmpty(fileInfos = FileOperateUtil.getFileInfo(softVersion, "1"))) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Rollback app,The lastest fileinfo.xml doesn't exist.");
                UpgradeStateHandler.getInstance().setAppRollbackState("30");
                return;
            }
            FileOperateUtil.fileReplaceOperate(backupResource, appPath, fileInfos, "1");
            UpgraderService.deleteRelativeDir(softVersion, zipFileName);
        }
        catch (IOException ex) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Rollback app process failed.");
            UpgradeStateHandler.getInstance().setAppRollbackState("30");
        }
    }
}

