/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.service;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.upgrader.constant.UpgraderConstants;
import com.huawei.support.icslite.upgrader.dto.FileInfoDto;
import com.huawei.support.icslite.upgrader.service.UpgradeStateHandler;
import com.huawei.support.icslite.upgrader.util.FileOperateUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeOperateService {
    public static final String CERT_PEM_CONTENT_THREE = "BgNVHQ4EFgQUDjkBfSbLAmrgyjRlUCChRGzsf54wHwYDVR0jBBgwFoAUDjkBfSbLAmrgyjRlUCChRGzsf54wQQYJKoZIhvcNAQEKMDSgDzANBglghkgBZQMEAgEFAKEcMBoGCSqGSIb3DQEBCDANBglghkgBZQMEAgEFAKIDAgEgA4ICAQBhnanpVOz0exdFfSyv8VxBZKL0XIYDue5nmeo0CJ2770Tj6NZawOJPkOAluzSAJpGKZdZgTfZdjKgRUmGAzL0IBdOf2lbmRyz4Qm1e6nTqB6TvveyeksnxfxDAQq0t2zbIv41OS3RObf5CT56TKR7mp7t6QR83Er8zaK8WbehFMx0puRTt+kST7b32Nzp2jI7jxlugi7+/oJoRdwYd7NKTdkpjLSBz3dfigt2Gp8U5BTXxAvO6hsVkb4OHbJ5n+h5avY8q/Hzzd2xc7bJFHVy5pL4nh/vM1z8/MRZUpxGLKOozNarYESVSzIZc9ovA08WKmaSqXkCgNwEv7K/cDCnKAp73aknUAGJg6zAN3BZikSLYM+V+Tmc4FR/UQG/+GSkdvg0kmxKt3izwoVctj/Je350VQLOgYkmOTQXdBCtMo8T5q/ZWq8mct1DtS4KaLxgLQQN214QS5MqY";
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UpgradeOperateService.class);

    private UpgradeOperateService() {
    }

    public static void upgradeApp(String resource, String appPath, String version) {
        try {
            List<FileInfoDto> fileInfos;
            UpgradeStateHandler.getInstance().setAppUpgradeState("20");
            File resourceFile = FileUtils.getFile(resource);
            if (!resourceFile.exists()) {
                UpgradeStateHandler.getInstance().setAppUpgradeState("40");
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "source file doesn't exist in upgrading process");
                return;
            }
            if (StringUtils.isBlank(version)) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "The lastest version  is empty!");
            }
            if (CollectionUtils.isEmpty(fileInfos = FileOperateUtil.getFileInfo(version, "0"))) {
                UpgradeStateHandler.getInstance().setAppUpgradeState("40");
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "Upgrade icslite, the fileInfo is null.");
                return;
            }
            String resourcePath = resource + File.separator + "ICSLite";
            FileOperateUtil.fileReplaceOperate(resourcePath, appPath, fileInfos, "0");
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "replacing upgrade file registered in fileInfo.xml finished.");
        }
        catch (IOException ex) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Upgrade app failed.", (Throwable)ex);
            UpgradeStateHandler.getInstance().setAppUpgradeState("41");
        }
    }

    public static void oldVersionBackUp(String version) {
        try {
            List<FileInfoDto> fileInfos;
            String oldVersionPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + UpgraderConstants.UPGRADE_BACKUP_OLDVERSION;
            File oldDirfile = FileUtils.getFile(oldVersionPath);
            if (oldDirfile.exists()) {
                IcsFileUtils.deleteFile(oldDirfile);
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "delete old backup file succeed.");
            }
            if (CollectionUtils.isEmpty(fileInfos = FileOperateUtil.getFileInfo(version, "2"))) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "Backup file in icslite, the fileInfo is null.");
                return;
            }
            String resource = IcsCommonServiceHandler.getInstance().getAppRootDir();
            String appPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + UpgraderConstants.UPGRADE_BACKUP_OLDVERSION;
            FileOperateUtil.fileReplaceOperate(resource, appPath, fileInfos, "2");
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Backup the current version files success.");
        }
        catch (IOException ex) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Backup app failed.");
        }
    }
}

