/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.verify.util.CMSVerify;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.upgrader.constant.UpgraderConstants;
import com.huawei.support.icslite.upgrader.dto.FileInfoDto;
import com.huawei.support.icslite.upgrader.messages.BubbleSettings;
import com.huawei.support.icslite.upgrader.messages.UpgradeProgressBar;
import com.huawei.support.icslite.upgrader.service.RollbackOperateService;
import com.huawei.support.icslite.upgrader.service.UpgradeOperateService;
import com.huawei.support.icslite.upgrader.service.UpgradeStateHandler;
import com.huawei.support.icslite.upgrader.service.UpgraderService;
import com.huawei.support.icslite.upgrader.util.FileOperateUtil;
import com.huawei.support.icslite.upgrader.util.FileShaCode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.dom4j.Document;

public class UpgradeProcess
implements Runnable {
    private static final String CERT_PEM_CONTENT_TWO = "GAy35FW5bNBtvYH3xN4ne0oGW6qWkgJQsDHG6iFZqRBKLx1O7yOhwvEdG5jfJwg26NK5ad75vM6LHA6tEPG9ttMhcmj9VgzUdAFOHOt1IlAkZ+odFn6Prte4i/M0bYZgD/LShlgtBp+iDrWD+zHfcWADEGEsEzxyX7CJviJBTnoUwKM0/CQGLzaUTcGKfmVRqvlxCuSGRYsZWlOyoGomiSzmHxCMKzshrHW+RTO6YidFvbt/eKM0TRl3sXm6S1+C+FRY25es4lrXBm1/7VIcYy8CAmBAzYscFkaJqDiOqZ2wH3nDmonZeLgL0gfhSN5XofsOa3+K0FwLGMSs8S6znSyFdmgsdAu53EzQQ/CDolyDKza38sqRMxa2FSvIrbjilypuUg6QH4p8XZdLac/D63s69rVbDgct9Yt39e7PCx51XLkQZevzW0wacuylvzyWTCHqvNHo3zVLvfhtfB70LkhTTnZIcJFSi/Qz62BfQwBriMLEtNaFDyVA1/ZyJLPaO0NvQ7T2tkkfsopSjGq8U9bcirLLyIJT3PW5j+zr96cO4nnO6TK2esXnBC6m/tqrNhKnQwIDAQABo2MwYTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAd";
    private static final int BACKUP_THRESHOLD = 55;
    private static final int SIGNATURE_THRESHOLD = 75;
    private static final int UPGRADE_THRESHOLD = 95;
    private static final int ROLLBACK_THRESHOLD = 110;
    private static final int SLEEP_MILLIS = 500;
    private static final int SLEEP_SECONDS = 5;
    private static final String PATH = IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgraderConstants.APP_UPGRADE_TEMP_DIR;
    private static final TypeReference<HashMap<String, String>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, String>>(){};
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UpgradeProcess.class);

    @Override
    public void run() {
        JSONObject heartData = UpgraderService.getJsonData(CommonConstants.UPGRADE_URL_DATA_JSON);
        String softVersion = null;
        String publishTime = null;
        String zipFileName = null;
        if (MapUtils.isNotEmpty(heartData)) {
            JSONObject clientUpgradeJson = UpgraderService.getJsonData(CommonConstants.SERVER_UPGRADE_PATH);
            softVersion = clientUpgradeJson.getString("clientVersion");
            publishTime = clientUpgradeJson.getString("publishTime");
            zipFileName = clientUpgradeJson.getString("clientName");
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Icslite upgrader obtain upgrade version and name.");
        IcsCommonServiceHandler.getInstance().exitApp();
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Icslite upgrader to stop icslite app.");
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "thread sleep occur error {0}.", e.toString());
        }
        UpgradeOperateService.oldVersionBackUp(softVersion);
        UpgradeProgressBar.setProcess(55);
        UpgradeOperateService.upgradeApp(IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgraderConstants.APP_UPGRADE_TEMP_DIR, IcsCommonServiceHandler.getInstance().getAppRootDir(), softVersion);
        if (StringUtils.equals(UpgradeStateHandler.getInstance().getAppUpgradeState(), "20")) {
            boolean isSuccess = this.verifySingature();
            if (!isSuccess) {
                UpgradeStateHandler.getInstance().setAppUpgradeState("40");
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "the fileCheckSum signature doesn't pass,app will rollback.");
            }
            UpgradeProgressBar.setProcess(75);
            if (isSuccess) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "cms verification passed.");
                this.verifyShaCodeProcessAndCleanFiles(softVersion, publishTime, zipFileName);
            }
        }
        if (StringUtils.equalsAny(UpgradeStateHandler.getInstance().getAppUpgradeState(), "40", "41")) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Upgrade failed,app will rollback immediately.");
            this.rollback(softVersion, zipFileName, UpgradeStateHandler.getInstance().getAppUpgradeState());
        }
    }

    private void verifyShaCodeProcessAndCleanFiles(String softVersion, String publishTime, String zipFileName) {
        boolean isSuccess;
        try {
            isSuccess = this.verifyShaCode(softVersion);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "internal file SHA code verify error.");
            isSuccess = false;
        }
        if (!isSuccess) {
            UpgradeStateHandler.getInstance().setAppUpgradeState("40");
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "the result of verifying internal file sha code failed,app will rollback.");
        }
        if (isSuccess) {
            UpgraderService.deleteRelativeDir(softVersion, zipFileName);
            this.updateSoftWareVersion(softVersion, publishTime);
            UpgradeProgressBar.setProcess(95);
        }
    }

    private void rollback(String softVersion, String zipFileName, String failStatusCode) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Upgrade failed,enter rollback method.");
        RollbackOperateService.rollBackProcess(IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + UpgraderConstants.UPGRADE_BACKUP_OLDVERSION, IcsCommonServiceHandler.getInstance().getAppRootDir(), softVersion, zipFileName);
        UpgradeProgressBar.setProcess(110);
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "rollback app,thread sleep error.", (Throwable)e);
        }
        BubbleSettings.bubbleWindowEvent(failStatusCode, UpgradeStateHandler.getInstance().getAppUpgradeState(), UpgradeStateHandler.getInstance().getAppRollbackState());
    }

    private void updateSoftWareVersion(String softVersion, String publishTime) {
        Document appUpgradeData = UpgraderService.getAppUpgradeData();
        UpgraderService.updateAppUpgradeXml(appUpgradeData, softVersion, publishTime, "seedIcslite");
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Icslite upgrader will restart icslite app.");
    }

    private boolean verifySingature() {
        StringBuffer builder = new StringBuffer();
        builder.append(UpgraderConstants.CERT_PEM_CONTENT_HEAD);
        builder.append("MIIGQjCCA/agAwIBAgIDPDrbMEEGCSqGSIb3DQEBCjA0oA8wDQYJYIZIAWUDBAIBBQChHDAaBgkqhkiG9w0BAQgwDQYJYIZIAWUDBAIBBQCiAwIBIDB8MQswCQYDVQQGEwJDTjEcMBoGA1UEChMTSHVhd2VpIFRlY2hub2xvZ2llczEnMCUGA1UECxMeSHVhd2VpIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MSYwJAYDVQQDEx1IdWF3ZWkgSW50ZWdyaXR5IFJvb3QgQ0EgLSBHMjAgFw0yMTAyMDcwOTM2NDZaGA8yMDUxMDUwNzA5MzY0NlowfDELMAkGA1UEBhMCQ04xHDAaBgNVBAoTE0h1YXdlaSBUZWNobm9sb2dpZXMxJzAlBgNVBAsTHkh1YXdlaSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEmMCQGA1UEAxMdSHVhd2VpIEludGVncml0eSBSb290IENBIC0gRzIwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDdiU8j/HUtpiSLjsmr1t1P/nBDTbxuun0OVciaQ6Oc+E6y1YXCUmFn+p1WwKEJQetkKbCWlcZch8I2G/f86J/Z4m4ZwZJSV04B/uKQ");
        builder.append(CERT_PEM_CONTENT_TWO);
        builder.append("BgNVHQ4EFgQUDjkBfSbLAmrgyjRlUCChRGzsf54wHwYDVR0jBBgwFoAUDjkBfSbLAmrgyjRlUCChRGzsf54wQQYJKoZIhvcNAQEKMDSgDzANBglghkgBZQMEAgEFAKEcMBoGCSqGSIb3DQEBCDANBglghkgBZQMEAgEFAKIDAgEgA4ICAQBhnanpVOz0exdFfSyv8VxBZKL0XIYDue5nmeo0CJ2770Tj6NZawOJPkOAluzSAJpGKZdZgTfZdjKgRUmGAzL0IBdOf2lbmRyz4Qm1e6nTqB6TvveyeksnxfxDAQq0t2zbIv41OS3RObf5CT56TKR7mp7t6QR83Er8zaK8WbehFMx0puRTt+kST7b32Nzp2jI7jxlugi7+/oJoRdwYd7NKTdkpjLSBz3dfigt2Gp8U5BTXxAvO6hsVkb4OHbJ5n+h5avY8q/Hzzd2xc7bJFHVy5pL4nh/vM1z8/MRZUpxGLKOozNarYESVSzIZc9ovA08WKmaSqXkCgNwEv7K/cDCnKAp73aknUAGJg6zAN3BZikSLYM+V+Tmc4FR/UQG/+GSkdvg0kmxKt3izwoVctj/Je350VQLOgYkmOTQXdBCtMo8T5q/ZWq8mct1DtS4KaLxgLQQN214QS5MqY");
        builder.append(UpgradeStateHandler.CERT_PEM_CONTENT_FOUR);
        builder.append("-----END CERTIFICATE-----");
        String content = builder.toString();
        byte[] crtFileData = content.getBytes(StandardCharsets.UTF_8);
        String crlFilePath = PATH + UpgraderConstants.CLIENT_CRL;
        String srcFilePath = PATH + UpgraderConstants.FILE_CHECK_SUM;
        String sigFilePath = PATH + UpgraderConstants.FILE_CHECK_SUM_CMS;
        if (!(FileUtils.getFile(crlFilePath).exists() && FileUtils.getFile(srcFilePath).exists() && FileUtils.getFile(sigFilePath).exists())) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "when verify fileCheckSum file,relativate file doesn't exist");
            return false;
        }
        CMSVerify cmsVerify = new CMSVerify();
        cmsVerify.addCrtData(crtFileData);
        cmsVerify.setSigFile(sigFilePath);
        cmsVerify.setSrcFile(srcFilePath);
        cmsVerify.addCrlFile(crlFilePath);
        boolean result = false;
        try {
            result = cmsVerify.verify();
        }
        catch (GeneralSecurityException | CMSException | AnnotatedException | OperatorCreationException | TSPException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "cms signature verify failed.", (Throwable)e);
        }
        return result;
    }

    private boolean verifyShaCode(String version) throws IOException {
        List<FileInfoDto> fileInfos = FileOperateUtil.getFileInfo(version, "3");
        if (CollectionUtils.isEmpty(fileInfos)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "cann't verify SHA code, the fileInfo is null.");
            return false;
        }
        String content = IcsFileUtils.readFileContent(PATH + UpgraderConstants.FILE_CHECK_SUM, "");
        JSONObject jsonObject = JSONObject.parseObject(content);
        String[] excludePath = null;
        String value = jsonObject.getString("ExcludePath");
        if (value != null) {
            excludePath = value.replace("[", "").replace("]", "").split(",");
        }
        HashMap<String, String> cmsMap = JSONObject.parseObject(jsonObject.toJSONString(), MAP_TYPE_REFERENCE, new Feature[0]);
        return this.verifyProcess(fileInfos, excludePath, cmsMap);
    }

    private boolean matchAnyExcludePattern(String path, String[] exclude) {
        if (exclude == null) {
            return false;
        }
        for (String pattern : exclude) {
            if (!StringUtils.startsWith(path, IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + pattern.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean verifyProcess(List<FileInfoDto> fileInfos, String[] excludePath, Map<String, String> cmsMap) throws IOException {
        for (FileInfoDto fileInfoDto : fileInfos) {
            if (StringUtils.startsWith(fileInfoDto.getRelativePath(), File.separator + "bin" + File.separator)) {
                fileInfoDto.setRelativePath("bin" + File.separator);
            }
            String filePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + fileInfoDto.getRelativePath();
            File files = FileUtils.getFile(filePath);
            if (this.matchAnyExcludePattern(files.getCanonicalPath(), excludePath)) continue;
            Map<String, String> upgradeMap = this.getUpgradeMap(files);
            Map<String, String> fileMap = this.getFileMap(filePath, cmsMap);
            if (this.verifySha(fileMap, upgradeMap)) continue;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "{0} file sha256 check failed", fileInfoDto.getRelativePath());
            return false;
        }
        return true;
    }

    private Map<String, String> getUpgradeMap(File files) throws IOException {
        LinkedList<File> queue = new LinkedList<File>();
        HashMap<String, String> shaMap = new HashMap<String, String>();
        queue.add(files);
        while (!CollectionUtils.isEmpty(queue)) {
            File[] fileList;
            File file = (File)queue.poll();
            if (file == null) continue;
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (basicFileAttributes.isDirectory() && (fileList = file.listFiles()) != null) {
                Collections.addAll(queue, fileList);
            }
            if (!basicFileAttributes.isRegularFile()) continue;
            String shaCode = FileShaCode.getFileSha(file);
            String key = file.getCanonicalPath().replace(IcsCommonServiceHandler.getInstance().getAppRootDir(), "");
            key = key.replace("\\", "/");
            shaMap.put(key, shaCode);
        }
        return shaMap;
    }

    private Map<String, String> getFileMap(String filePath, Map<String, String> cmsMap) {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        String relativePath = filePath.replace(IcsCommonServiceHandler.getInstance().getAppRootDir(), "").replace("\\", "/");
        for (Map.Entry<String, String> entry : cmsMap.entrySet()) {
            if (!StringUtils.startsWith(entry.getKey(), relativePath)) continue;
            fileMap.put(entry.getKey(), entry.getValue());
        }
        return fileMap;
    }

    private boolean verifySha(Map<String, String> fileMap, Map<String, String> upgradeMap) {
        if (MapUtils.isEmpty(fileMap) || MapUtils.isEmpty(upgradeMap)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "SHA code verify failed,one of maps is empty.");
            return false;
        }
        for (Map.Entry<String, String> entry : upgradeMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty(key)) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "the relative path is null in upgradeMap.");
                return false;
            }
            if (StringUtils.isEmpty(value)) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "the SHA code value is null in upgradeMap,the relative path : {0}", key);
                return false;
            }
            if (!fileMap.containsKey(key)) {
                CodeCCUtils.INSTANCE.warnLog(LOGGER, "the relative path {0} doesn't exist in fileCheckSum file", key);
                continue;
            }
            if (!value.equals(fileMap.get(key))) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "file sha code value is different,the relative path:{0}", key);
                return false;
            }
            fileMap.remove(key);
        }
        if (fileMap.size() > 0) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "splus relative path and sha code {0}", fileMap.toString());
            return false;
        }
        return true;
    }
}

