/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.service;

import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.upgrader.constant.UpgraderConstants;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;

public class UpgraderService {
    public static final String CERT_PEM_CONTENT_TAIL = "-----END CERTIFICATE-----";
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(UpgraderService.class);

    public static Document getAppUpgradeData() {
        String filePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + CommonConstants.APP_UPGRADE_PATH;
        return XmlDom4jUtils.getDocument(filePath);
    }

    public static void updateAppUpgradeXml(Document document, String version, String publishTime, String origin) {
        if (document == null || StringUtils.isAnyBlank(version, publishTime, origin)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to update the application upgrade XML file.");
            return;
        }
        if ("seedIcslite".equals(origin)) {
            UpgraderService.rebuildIcsliteDocument(document, version, publishTime);
        }
    }

    private static void rebuildIcsliteDocument(Document document, String version, String publishTime) {
        Element rootElement = document.getRootElement();
        List<Element> elements = rootElement.elements();
        for (Element element : elements) {
            QName elementName = element.getQName();
            if (elementName == null || !StringUtils.equals("software", elementName.getName())) continue;
            List<Attribute> attributes = element.attributes();
            for (Attribute attr : attributes) {
                QName qName = attr.getQName();
                if (attr.getQName() == null) continue;
                String attrName = qName.getName();
                if (StringUtils.equals(attrName, "version")) {
                    attr.setValue(version);
                }
                if (!StringUtils.equals(attrName, "publishTime")) continue;
                attr.setValue(publishTime);
            }
        }
        String filePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + CommonConstants.APP_UPGRADE_PATH;
        XmlDom4jUtils.writeXml(document, filePath);
    }

    public static JSONObject getJsonData(String path) {
        String jsonData = IcsFileUtils.readFileContent(IcsCommonServiceHandler.getInstance().getAppRootDir() + path, null);
        if (StringUtils.isBlank(jsonData)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to read the JSON file.");
            return new JSONObject();
        }
        return JSONObject.parseObject(jsonData);
    }

    public static void deleteRelativeDir(String softVersion, String zipFileName) {
        if (StringUtils.isBlank(softVersion) || StringUtils.isBlank(zipFileName)) {
            return;
        }
        File tempDir = FileUtils.getFile(IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgraderConstants.APP_UPGRADE_TEMP_DIR);
        try {
            IcsFileUtils.deleteFile(tempDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "delete temp directory failed.");
        }
        File downloadDir = FileUtils.getFile(IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + softVersion);
        try {
            IcsFileUtils.deleteFile(downloadDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "delete temp download directory failed.");
        }
        File oldVerisionDir = FileUtils.getFile(IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + "backup");
        try {
            IcsFileUtils.deleteFile(oldVerisionDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "delete temp oldversion directory failed.");
        }
    }
}

