/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.upgrader.constant.UpgraderConstants;
import com.huawei.support.icslite.upgrader.dto.FileInfoDto;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;

public class FileOperateUtil {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(FileOperateUtil.class);

    private FileOperateUtil() {
    }

    public static void fileReplaceOperate(String resource, String appPath, List<FileInfoDto> fileInfos, String replaceType) throws IOException {
        for (FileInfoDto fileInfoDto : fileInfos) {
            String relativePath = fileInfoDto.getRelativePath();
            String pathType = fileInfoDto.getPathType();
            String operationType = fileInfoDto.getOperationType();
            String orgin = resource + File.separator + relativePath;
            String target = appPath + File.separator + relativePath;
            File file = FileUtils.getFile(target);
            IcsFileUtils.deleteFile(file);
            if (StringUtils.equalsAny(replaceType, "2", "1")) {
                FileOperateUtil.backupAndRollbackFile(orgin, pathType, target);
            }
            if (!StringUtils.equals(replaceType, "0")) continue;
            FileOperateUtil.upgradeFile(orgin, pathType, target, operationType);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "upgrade the {0} file successfully.", relativePath);
        }
    }

    private static void backupAndRollbackFile(String orgin, String pathType, String target) throws IOException {
        File srcFile = FileUtils.getFile(orgin);
        if (!srcFile.exists()) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "backup or rollback,resource file {0} doesn't exist.", srcFile.getName());
            return;
        }
        if ("2".equals(pathType)) {
            IcsFileUtils.copyDirectory(orgin, target);
        }
        if ("1".equals(pathType)) {
            IcsFileUtils.copyFile(orgin, target);
        }
    }

    private static void upgradeFile(String orgin, String pathType, String target, String operationType) throws IOException {
        if (StringUtils.equals(operationType, "1")) {
            if (StringUtils.equals(pathType, "2")) {
                IcsFileUtils.copyDirectory(orgin, target);
            }
            if (StringUtils.equals(pathType, "1")) {
                IcsFileUtils.copyFile(orgin, target);
            }
        }
        File file = FileUtils.getFile(target);
        if (StringUtils.equals(operationType, "2") && file.exists()) {
            FileUtils.deleteDirectory(file);
        }
    }

    public static List<FileInfoDto> getFileInfo(String version, String replaceType) {
        if (StringUtils.isBlank(version)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Failed to obtain the current software version information. The version information is empty.");
            return ListUtils.emptyIfNull(null);
        }
        ArrayList<FileInfoDto> list = new ArrayList<FileInfoDto>();
        Document fileData = FileOperateUtil.getFileData();
        if (fileData == null) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Failed to obtain the update file data information.");
            return ListUtils.emptyIfNull(null);
        }
        Element rootElement = fileData.getRootElement();
        List<Element> elements = rootElement.elements();
        for (Element element : elements) {
            QName qname = element.getQName();
            if (qname == null) continue;
            Iterator<Element> elementIterator = element.elementIterator();
            while (elementIterator.hasNext()) {
                Element elem = elementIterator.next();
                QName childQname = elem.getQName();
                if (childQname == null || StringUtils.equals(replaceType, "3") && (StringUtils.equals(qname.getName(), "exclude") || StringUtils.equals(childQname.getName(), "no-check-file"))) continue;
                String strChildQname = childQname.getName();
                String strParentQname = qname.getName();
                FileInfoDto fileInfoDto = FileOperateUtil.getFileInfoDtoList(strChildQname, strParentQname, elem);
                if (StringUtils.equalsAny(qname.getName(), "include", "bin")) {
                    fileInfoDto.setOperationType("1");
                }
                if (StringUtils.equals(qname.getName(), "exclude")) {
                    fileInfoDto.setOperationType("2");
                }
                list.add(fileInfoDto);
            }
        }
        return list;
    }

    public static Document getFileData() {
        String filePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgraderConstants.APP_UPGRADE_TEMP_DIR + UpgraderConstants.APP_UPGRADE_FILEINFO_PATH;
        return XmlDom4jUtils.getDocument(filePath);
    }

    private static FileInfoDto getFileInfoDtoList(String strChildQname, String strParentQname, Element childElement) {
        FileInfoDto fileInfoDto = new FileInfoDto();
        if (StringUtils.equals(strChildQname, "dir")) {
            if (StringUtils.equals(strParentQname, "bin")) {
                fileInfoDto.setRelativePath(File.separator + "bin" + File.separator + childElement.getText());
            } else {
                fileInfoDto.setRelativePath(childElement.getText());
            }
            fileInfoDto.setPathType("2");
        }
        if (StringUtils.equalsAny(strChildQname, "file", "no-check-file")) {
            if (StringUtils.equals(strParentQname, "bin")) {
                fileInfoDto.setRelativePath(File.separator + "bin" + File.separator + childElement.getText());
            } else {
                fileInfoDto.setRelativePath(childElement.getText());
            }
            fileInfoDto.setPathType("1");
        }
        return fileInfoDto;
    }

    public static void setWindowsUiStyle() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "set UI style error.", (Throwable)e);
        }
    }

    public static boolean deleteUpgradeFile() {
        String path = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + "upgradeOperate.txt";
        File file = FileUtils.getFile(path);
        boolean isDel = true;
        try {
            IcsFileUtils.deleteFile(file);
        }
        catch (IOException e) {
            isDel = false;
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "delete UpgradeOperate.txt failed");
        }
        return isDel;
    }
}

