/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.upgrader.util;

import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.upgrader.constant.UpgraderConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileShaCode {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(FileShaCode.class);
    private static final String PATH = IcsCommonServiceHandler.getInstance().getAppRootDir() + UpgraderConstants.APP_UPGRADE_TEMP_DIR;
    private static final int LENGTH = 1024;
    private static String content = IcsFileUtils.readFileContent(PATH + UpgraderConstants.FILE_CHECK_SUM, "");

    public static String getFileSha(File file) {
        JSONObject jsonObject = JSONObject.parseObject(content);
        String shaType = jsonObject.getString("DigestAlgorithms");
        if (StringUtils.isEmpty(shaType)) {
            shaType = "SHA-256";
        }
        return FileShaCode.getHash(file, shaType);
    }

    private static String getHash(File file, String hashType) {
        String result = null;
        try (BufferedInputStream fis = new BufferedInputStream(FileUtils.openInputStream(file));){
            byte[] buffer = new byte[1024];
            MessageDigest md = MessageDigest.getInstance(hashType);
            int numRead = 0;
            while ((numRead = fis.read(buffer)) > 0) {
                md.update(buffer, 0, numRead);
            }
            result = new HexBinaryAdapter().marshal(md.digest());
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get {0} IO error.", hashType);
        }
        catch (NoSuchAlgorithmException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get {0} IO error.", hashType, e);
        }
        return result;
    }
}

