/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.operationlogservice.client.handler;

import com.huawei.support.cbb.util.datetime.DateUtil;
import com.huawei.support.cbb.util.security.LoggerUtils;
import com.huawei.support.cbb.util.uuid.UUIDUtils;
import com.huawei.support.operationlogservice.client.handler.OperationEnums;
import com.huawei.support.operationlogservice.client.handler.OperationLogMessage;
import com.huawei.support.operationlogservice.model.OperationLog;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLogUtils {
    private static final Logger OPERATION_LOGGER = LoggerFactory.getLogger("operation_logger");
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationLogUtils.class);
    private static final String OPERATION_SUCCESS = "0";
    private static final String OPERATION_FAIL = "1";

    public static void addOperationLogMessage(OperationLogMessage operationLogMessage, OperationEnums.LogLevel logLevel) {
        if (!OperationLogUtils.checkLogParam(operationLogMessage)) {
            LoggerUtils.errorLog((Logger)LOGGER, (String)"Fail to add operationlogmessage: checkLogParam failed.", (Object[])new Object[0]);
            return;
        }
        operationLogMessage.setLogPrintTime(DateUtil.formatDatetime((Date)new Date()));
        if (logLevel == OperationEnums.LogLevel.INFO) {
            LoggerUtils.infoLog((Logger)OPERATION_LOGGER, (String)operationLogMessage.toJsonString(), (Object[])new Object[0]);
            return;
        }
        if (logLevel == OperationEnums.LogLevel.WARN) {
            LoggerUtils.warnLog((Logger)OPERATION_LOGGER, (String)operationLogMessage.toJsonString(), (Object[])new Object[0]);
            return;
        }
        if (logLevel == OperationEnums.LogLevel.ERROR) {
            LoggerUtils.errorLog((Logger)OPERATION_LOGGER, (String)operationLogMessage.toJsonString(), (Object[])new Object[0]);
        }
    }

    public static void addOperationLogMessage(OperationLogMessage operationLogMessage) {
        OperationLogUtils.addOperationLogMessage(operationLogMessage, OperationEnums.LogLevel.INFO);
    }

    public static void addOperationLog(OperationLog operationLog, OperationEnums.LogLevel logLevel) {
        OperationLogMessage logMessage = new OperationLogMessage.OperationLogMessageBuilder().logId(StringUtils.isEmpty(operationLog.getId()) ? UUIDUtils.getUUID() : operationLog.getId()).systemType(operationLog.getSystemType()).objectType(operationLog.getModuleType()).objectId(operationLog.getModuleId()).operationType(operationLog.getOperationType()).operationContext(operationLog.getOperation()).operator(operationLog.getOperator()).operatorIp(operationLog.getClientIp()).operationResult(OperationLogUtils.getStatus(operationLog.getStatus())).operationTime(StringUtils.isEmpty(operationLog.getOperationTime()) ? DateUtil.formatDatetime((Date)new Date()) : operationLog.getOperationTime()).build();
        OperationLogUtils.addOperationLogMessage(logMessage, logLevel);
    }

    public static void addOperationLog(OperationLog operationLog) {
        OperationLogUtils.addOperationLog(operationLog, OperationEnums.LogLevel.INFO);
    }

    private static String getStatus(String status) {
        if (StringUtils.equals(status, OPERATION_SUCCESS)) {
            return OperationEnums.Result.SUCCESS.value;
        }
        if (StringUtils.equals(status, OPERATION_FAIL)) {
            return OperationEnums.Result.FAILED.value;
        }
        return status;
    }

    private static boolean checkLogParam(OperationLogMessage log) {
        if (log == null) {
            return false;
        }
        return StringUtils.isNoneEmpty(log.getLogId(), log.getOperator(), log.getOperatorIp(), log.getObjectType(), log.getObjectId(), log.getOperationTime(), log.getOperationType(), log.getOperationResult());
    }
}

